package com.unity3d.services.ads.gmascar.managers;

import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.services.ads.gmascar.GMA;

import com.unity3d.services.core.configuration.IExperiments;

public class BiddingManagerFactory {

	private static BiddingManagerFactory instance;

	private BiddingManagerFactory() {}

	public static BiddingManagerFactory getInstance() {
		if (instance == null) {
			instance = new BiddingManagerFactory();
		}
		return instance;
	}

	public BiddingBaseManager createManager(IUnityAdsTokenListener unityAdsTokenListener,
											IExperiments experiments) {
		if (GMA.getInstance().hasSCARBiddingSupport()) {
			return getExperiment(unityAdsTokenListener, experiments);
		}

		return new BiddingDisabledManager(unityAdsTokenListener);
	}

	private BiddingBaseManager getExperiment(IUnityAdsTokenListener unityAdsTokenListener,
											 IExperiments experiments) {
		if (experiments == null || experiments.getScarBiddingManager() == null) {
			return new BiddingDisabledManager(unityAdsTokenListener);
		}

		String biddingManager = experiments.getScarBiddingManager();
		ScarBiddingManagerType biddingManagerType = ScarBiddingManagerType.fromName(biddingManager);

		switch (biddingManagerType) {
			case EAGER:
				return new BiddingEagerManager(experiments.isScarBannerHbEnabled(), unityAdsTokenListener);
			case DISABLED:
			default:
				return new BiddingDisabledManager(unityAdsTokenListener);
		}
	}
}