package com.unity3d.ads.core.extensions

import org.json.JSONObject

/**
 * Converts a JSONObject to a built-in Map.
 *
 * Iterates over the keys of the JSONObject and creates a new map. If the value is a JSON null or undefined value, it is replaced with `null`.
 * The resulting map will have string keys and can contain values of any type.
 */
fun JSONObject.toBuiltInMap(): Map<String, Any?> = keys().asSequence().associateWith { value ->
    opt(value)?.takeIf { "$it" != "undefined" &&  "$it" != "null" }
}