package com.unity3d.ads.core.extensions

import com.unity3d.services.SDKErrorHandler
import com.unity3d.services.UnityAdsConstants.ErrorHandler.ERROR_HANDLER_STACK_TRACE_LINES_MAX
import java.io.PrintWriter
import java.io.StringWriter

fun Throwable.retrieveUnityCrashValue(): String = this.stackTrace.find {
    it?.className?.contains(SDKErrorHandler.UNITY_PACKAGE) ?: false
}?.let {
    val className = it.fileName ?: SDKErrorHandler.UNKNOWN_FILE
    val line = it.lineNumber
    "${className}_$line"
} ?: SDKErrorHandler.UNKNOWN_FILE

fun Throwable.getShortenedStackTrace(maxLines: Int = ERROR_HANDLER_STACK_TRACE_LINES_MAX): String {
    try {
        StringWriter().use { stringWriter ->
            PrintWriter(stringWriter).use { printWriter ->
                this.printStackTrace(printWriter)
                return stringWriter.toString()
                    .trim()
                    .lineSequence()
                    .take(maxLines)
                    .joinToString("\n")
            }
        }
    } catch (t: Throwable) {
        return ""
    }
}