package com.unity3d.ads.core.domain

import android.content.Context
import android.content.Intent
import android.net.Uri



class AndroidHandleOpenUrl(
    private val context: Context
) : HandleOpenUrl {
    override fun invoke(url: String, packageName: String?) {
        val intent = Intent().apply {
            packageName?.takeIf(String::isNotEmpty).let(::setPackage)
            action = Intent.ACTION_VIEW
            data = Uri.parse(url)
            flags = Intent.FLAG_ACTIVITY_NEW_TASK
        }

        context.startActivity(intent)
    }
}