/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.device.reader.IDeviceInfoDataCompressor;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeviceInfoReaderCompressorWithMetrics
implements IDeviceInfoDataCompressor {
    private final IDeviceInfoDataCompressor _deviceInfoDataCompressor;
    private final SDKMetricsSender _sdkMetricsSender;
    private long _startTimeInfo;
    private long _startTimeCompression;
    private long _endTime;

    public DeviceInfoReaderCompressorWithMetrics(IDeviceInfoDataCompressor deviceInfoDataCompressor, SDKMetricsSender sdkMetricsSender) {
        this._deviceInfoDataCompressor = deviceInfoDataCompressor;
        this._sdkMetricsSender = sdkMetricsSender;
    }

    @Override
    public byte[] getDeviceData() {
        if (this._deviceInfoDataCompressor == null) {
            return new byte[0];
        }
        this._startTimeInfo = System.nanoTime();
        Map<String, Object> deviceInfo = this.getDeviceInfo();
        byte[] zippedData = this.compressDeviceInfo(deviceInfo);
        this.sendDeviceInfoMetrics();
        return zippedData;
    }

    @Override
    public Map<String, Object> getDeviceInfo() {
        return this._deviceInfoDataCompressor.getDeviceInfo();
    }

    @Override
    public byte[] compressDeviceInfo(Map<String, Object> deviceData) {
        this._startTimeCompression = System.nanoTime();
        byte[] zippedData = this._deviceInfoDataCompressor.compressDeviceInfo(deviceData);
        this._endTime = System.nanoTime();
        return zippedData;
    }

    private long getDeviceInfoCollectionDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this._startTimeCompression - this._startTimeInfo);
    }

    private long getCompressionDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this._endTime - this._startTimeCompression);
    }

    private void sendDeviceInfoMetrics() {
        this._sdkMetricsSender.sendMetric(TSIMetric.newDeviceInfoCollectionLatency(this.getDeviceInfoCollectionDuration()));
        this._sdkMetricsSender.sendMetric(TSIMetric.newDeviceInfoCompressionLatency(this.getCompressionDuration()));
    }
}

