/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.ads.gmascar.managers.ScarBiddingManagerType;
import com.unity3d.services.core.configuration.ExperimentAppliedRule;
import com.unity3d.services.core.configuration.ExperimentObject;
import com.unity3d.services.core.configuration.ExperimentsBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class ExperimentObjects
extends ExperimentsBase {
    private final JSONObject _experimentObjetsData;
    private final Map<String, ExperimentObject> _experimentObjects = new HashMap<String, ExperimentObject>();

    public ExperimentObjects(JSONObject experimentObjects) {
        if (experimentObjects != null) {
            this._experimentObjetsData = experimentObjects;
            Iterator it = experimentObjects.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                this._experimentObjects.put(key, new ExperimentObject(experimentObjects.optJSONObject(key)));
            }
        } else {
            this._experimentObjetsData = new JSONObject();
        }
    }

    public ExperimentObject getExperimentObject(String experimentName) {
        return this._experimentObjects.get(experimentName);
    }

    @Override
    public boolean shouldNativeTokenAwaitPrivacy() {
        return this.getExperimentValueOrDefault("tsi_prw");
    }

    @Override
    public boolean isWebAssetAdCaching() {
        return this.getExperimentValueOrDefault("wac");
    }

    @Override
    public boolean isWebGestureNotRequired() {
        return this.getExperimentValueOrDefault("wgr");
    }

    @Override
    public boolean isScarInitEnabled() {
        return this.getExperimentValueOrDefault("scar_init");
    }

    @Override
    public boolean isJetpackLifecycle() {
        return this.getExperimentValueOrDefault("gjl");
    }

    @Override
    public boolean isOkHttpEnabled() {
        return this.getExperimentValueOrDefault("okhttp");
    }

    @Override
    public boolean isWebMessageEnabled() {
        return this.getExperimentValueOrDefault("jwm");
    }

    @Override
    public boolean isWebViewAsyncDownloadEnabled() {
        return this.getExperimentValueOrDefault("wad");
    }

    @Override
    public boolean isNativeShowTimeoutDisabled() {
        return this.getExperimentValueOrDefault("nstd");
    }

    @Override
    public boolean isNativeLoadTimeoutDisabled() {
        return this.getExperimentValueOrDefault("nltd");
    }

    @Override
    public boolean isCaptureHDRCapabilitiesEnabled() {
        return this.getExperimentValueOrDefault("hdrc");
    }

    @Override
    public boolean isScarBannerHbEnabled() {
        return this.getExperimentValueOrDefault("scar_bn");
    }

    @Override
    public String getScarBiddingManager() {
        return this.getExperimentValue("scar_bm", ScarBiddingManagerType.DISABLED.getName());
    }

    @Override
    public boolean isPCCheckEnabled() {
        return this.getExperimentValueOrDefault("pc_check");
    }

    @Override
    public boolean isBoldSdkNextSessionEnabled() {
        return this.getExperimentValueOrDefault("boldSdkNextSessionEnabled");
    }

    private String getExperimentValue(String experimentName, String defaultValue) {
        ExperimentObject expo = this.getExperimentObject(experimentName);
        return expo != null ? expo.getStringValue() : defaultValue;
    }

    private boolean getExperimentValue(String experimentName, boolean defaultValue) {
        ExperimentObject expo = this.getExperimentObject(experimentName);
        return expo != null ? expo.getBooleanValue() : defaultValue;
    }

    private boolean getExperimentValueOrDefault(String experimentName) {
        return this.getExperimentValue(experimentName, false);
    }

    @Override
    public JSONObject getExperimentsAsJson() {
        return this._experimentObjetsData;
    }

    @Override
    public Map<String, String> getExperimentTags() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry<String, ExperimentObject> entry : this._experimentObjects.entrySet()) {
            map2.put(entry.getKey(), entry.getValue().getStringValue());
        }
        return map2;
    }

    @Override
    public JSONObject getCurrentSessionExperiments() {
        return this.getExperimentWithAppliedRule(ExperimentAppliedRule.IMMEDIATE);
    }

    @Override
    public JSONObject getNextSessionExperiments() {
        return this.getExperimentWithAppliedRule(ExperimentAppliedRule.NEXT);
    }

    private JSONObject getExperimentWithAppliedRule(ExperimentAppliedRule experimentAppliedRule) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry<String, ExperimentObject> entry : this._experimentObjects.entrySet()) {
            if (entry.getValue().getAppliedRule() != experimentAppliedRule) continue;
            map2.put(entry.getKey(), entry.getValue().getStringValue());
        }
        return new JSONObject(map2);
    }
}

