/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.lang.ref.WeakReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Intent {
    private static WeakReference<Activity> _activeActivity;

    @WebViewExposed
    public static void launch(JSONObject intentData, WebViewCallback callback2) {
        android.content.Intent intent;
        String className = (String)intentData.opt("className");
        String packageName = (String)intentData.opt("packageName");
        String action = (String)intentData.opt("action");
        String uri = (String)intentData.opt("uri");
        String mimeType = (String)intentData.opt("mimeType");
        JSONArray categories = (JSONArray)intentData.opt("categories");
        Integer flags = (Integer)intentData.opt("flags");
        JSONArray extras = (JSONArray)intentData.opt("extras");
        if (packageName != null && className == null && action == null && mimeType == null) {
            PackageManager pm = ClientProperties.getApplicationContext().getPackageManager();
            intent = pm.getLaunchIntentForPackage(packageName);
            if (intent != null && flags > -1) {
                intent.addFlags(flags.intValue());
            }
        } else {
            intent = new android.content.Intent();
            if (className != null && packageName != null) {
                intent.setClassName(packageName, className);
            } else if (packageName != null) {
                intent.setPackage(packageName);
            }
            if (action != null) {
                intent.setAction(action);
            }
            if (uri != null && mimeType != null) {
                intent.setDataAndType(Uri.parse((String)uri), mimeType);
            } else if (uri != null) {
                intent.setData(Uri.parse((String)uri));
            } else if (mimeType != null) {
                intent.setType(mimeType);
            }
            if (flags != null && flags > -1) {
                intent.setFlags(flags.intValue());
            }
            if (!Intent.setCategories(intent, categories)) {
                callback2.error(IntentError.COULDNT_PARSE_CATEGORIES, categories);
            }
            if (!Intent.setExtras(intent, extras)) {
                callback2.error(IntentError.COULDNT_PARSE_EXTRAS, extras);
            }
        }
        if (intent != null) {
            if (Intent.getStartingActivity() != null) {
                Intent.getStartingActivity().startActivity(intent);
                callback2.invoke(new Object[0]);
            } else {
                callback2.error(IntentError.ACTIVITY_WAS_NULL, new Object[0]);
            }
        } else {
            callback2.error(IntentError.INTENT_WAS_NULL, new Object[0]);
        }
    }

    private static boolean setCategories(android.content.Intent intent, JSONArray categories) {
        if (categories != null && categories.length() > 0) {
            for (int i = 0; i < categories.length(); ++i) {
                try {
                    intent.addCategory(categories.getString(i));
                    continue;
                }
                catch (Exception e) {
                    DeviceLog.exception("Couldn't parse categories for intent", e);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean setExtras(android.content.Intent intent, JSONArray extras) {
        if (extras != null) {
            for (int i = 0; i < extras.length(); ++i) {
                Object value;
                String key;
                try {
                    JSONObject item = extras.getJSONObject(i);
                    key = item.getString("key");
                    value = item.get("value");
                }
                catch (Exception e) {
                    DeviceLog.exception("Couldn't parse extras", e);
                    return false;
                }
                if (Intent.setExtra(intent, key, value)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean setExtra(android.content.Intent intent, String key, Object value) {
        if (value instanceof String) {
            intent.putExtra(key, (String)value);
        } else if (value instanceof Integer) {
            intent.putExtra(key, ((Integer)value).intValue());
        } else if (value instanceof Double) {
            intent.putExtra(key, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            intent.putExtra(key, ((Boolean)value).booleanValue());
        } else {
            DeviceLog.error("Unable to parse launch intent extra " + key);
            return false;
        }
        return true;
    }

    private static Activity getStartingActivity() {
        Activity act = null;
        if (_activeActivity != null && _activeActivity.get() != null) {
            act = (Activity)_activeActivity.get();
        } else if (ClientProperties.getActivity() != null) {
            act = ClientProperties.getActivity();
        }
        return act;
    }

    public static void setActiveActivity(Activity activity) {
        _activeActivity = activity == null ? null : new WeakReference<Activity>(activity);
    }

    public static void removeActiveActivity(Activity activity) {
        if (_activeActivity != null && _activeActivity.get() != null && activity != null && activity.equals(_activeActivity.get())) {
            _activeActivity = null;
        }
    }

    @WebViewExposed
    public static void canOpenIntent(JSONObject intentData, WebViewCallback callback2) {
        try {
            android.content.Intent intent = Intent.intentFromMetadata(intentData);
            boolean resolvable = Intent.checkIntentResolvable(intent);
            callback2.invoke(resolvable);
        }
        catch (IntentException e) {
            DeviceLog.exception("Couldn't resolve intent", e);
            callback2.error(e.getError(), e.getField());
        }
    }

    @WebViewExposed
    public static void canOpenIntents(JSONArray intents, WebViewCallback callback2) {
        JSONObject results = new JSONObject();
        int len = intents.length();
        for (int i = 0; i < len; ++i) {
            JSONObject intentData = intents.optJSONObject(i);
            String id = intentData.optString("id");
            try {
                android.content.Intent intent = Intent.intentFromMetadata(intentData);
                boolean resolvable = Intent.checkIntentResolvable(intent);
                results.put(id, resolvable);
                continue;
            }
            catch (IntentException e) {
                DeviceLog.exception("Exception parsing intent", e);
                callback2.error(e.getError(), e.getField());
                return;
            }
            catch (JSONException e) {
                callback2.error(IntentError.JSON_EXCEPTION, e.getMessage());
                return;
            }
        }
        callback2.invoke(results);
    }

    private static boolean checkIntentResolvable(android.content.Intent intent) {
        PackageManager packageManager = ClientProperties.getApplicationContext().getPackageManager();
        return packageManager.resolveActivity(intent, 0) != null;
    }

    private static android.content.Intent intentFromMetadata(JSONObject json) throws IntentException {
        android.content.Intent intent;
        String className = (String)json.opt("className");
        String packageName = (String)json.opt("packageName");
        String action = (String)json.opt("action");
        String uri = (String)json.opt("uri");
        String mimeType = (String)json.opt("mimeType");
        JSONArray categories = (JSONArray)json.opt("categories");
        Integer flags = (Integer)json.opt("flags");
        JSONArray extras = (JSONArray)json.opt("extras");
        if (packageName != null && className == null && action == null && mimeType == null) {
            PackageManager pm = ClientProperties.getApplicationContext().getPackageManager();
            intent = pm.getLaunchIntentForPackage(packageName);
            if (intent != null && flags > -1) {
                intent.addFlags(flags.intValue());
            }
        } else {
            intent = new android.content.Intent();
            if (className != null && packageName != null) {
                intent.setClassName(packageName, className);
            }
            if (action != null) {
                intent.setAction(action);
            }
            if (uri != null) {
                intent.setData(Uri.parse((String)uri));
            }
            if (mimeType != null) {
                intent.setType(mimeType);
            }
            if (flags != null && flags > -1) {
                intent.setFlags(flags.intValue());
            }
            if (!Intent.setCategories(intent, categories)) {
                throw new IntentException(IntentError.COULDNT_PARSE_CATEGORIES, categories);
            }
            if (!Intent.setExtras(intent, extras)) {
                throw new IntentException(IntentError.COULDNT_PARSE_EXTRAS, extras);
            }
        }
        return intent;
    }

    public static enum IntentError {
        COULDNT_PARSE_EXTRAS,
        COULDNT_PARSE_CATEGORIES,
        INTENT_WAS_NULL,
        JSON_EXCEPTION,
        ACTIVITY_WAS_NULL;

    }

    private static class IntentException
    extends Exception {
        private IntentError error;
        private Object field;

        public IntentException(IntentError error2, Object field) {
            this.error = error2;
            this.field = field;
        }

        public IntentError getError() {
            return this.error;
        }

        public Object getField() {
            return this.field;
        }
    }
}

