package com.unity3d.ads.core.domain

import com.unity3d.services.core.di.ServiceProvider.IO_DISPATCHER
import com.unity3d.ads.core.extensions.getHeadersMap
import com.unity3d.services.core.network.core.HttpClient
import com.unity3d.services.core.network.model.HttpRequest
import com.unity3d.services.core.network.model.HttpRequest.Companion.DEFAULT_TIMEOUT
import com.unity3d.services.core.network.model.HttpResponse
import com.unity3d.services.core.network.model.RequestType
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext
import org.json.JSONArray




class AndroidExecuteAdViewerRequest(
    private val ioDispatcher: CoroutineDispatcher,
    private val httpClient: HttpClient,
) : ExecuteAdViewerRequest {

    override suspend operator fun invoke(type: RequestType, parameters: Array<Any>): HttpResponse = withContext(ioDispatcher) {
        val request = createRequest(type, parameters)
        httpClient.execute(request)
    }

    private fun createRequest(type: RequestType, parameters: Array<Any>): HttpRequest {

        val url = parameters.getOrNull(1) as String?
        require(!url.isNullOrEmpty())

        return when (type) {
            RequestType.GET, RequestType.HEAD -> {
                val headers = parameters.getOrNull(2) as JSONArray?
                val connectTimeout = parameters.getOrNull(3) as Int?
                val readTimeout = parameters.getOrNull(4) as Int?

                HttpRequest(
                    baseURL = url,
                    method = type,
                    headers = headers?.getHeadersMap() ?: emptyMap(),
                    connectTimeout = connectTimeout ?: DEFAULT_TIMEOUT,
                    readTimeout = readTimeout ?: DEFAULT_TIMEOUT,
                )
            }
            RequestType.POST -> {
                val body = parameters.getOrNull(2) as String?
                val headers = parameters.getOrNull(3) as JSONArray?
                val connectTimeout = parameters.getOrNull(4) as Int?
                val readTimeout = parameters.getOrNull(5) as Int?

                HttpRequest(
                    baseURL = url,
                    method = type,
                    headers = headers?.getHeadersMap() ?: emptyMap(),
                    body = body,
                    connectTimeout = connectTimeout ?: DEFAULT_TIMEOUT,
                    readTimeout = readTimeout ?: DEFAULT_TIMEOUT,
                )
            }
        }

    }
}