package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.datasource.VolumeSettingsChange
import gatewayprotocol.v1.AllowedPiiOuterClass.AllowedPii
import gatewayprotocol.v1.DynamicDeviceInfoOuterClass.DynamicDeviceInfo
import gatewayprotocol.v1.PiiOuterClass.Pii
import gatewayprotocol.v1.StaticDeviceInfoOuterClass.StaticDeviceInfo
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.MutableStateFlow

internal interface DeviceInfoRepository {
    val allowedPii: MutableStateFlow<AllowedPii>
    suspend fun staticDeviceInfo(): StaticDeviceInfo
    fun cachedStaticDeviceInfo(): StaticDeviceInfo
    val dynamicDeviceInfo: DynamicDeviceInfo
    val piiData: Pii
    val volumeSettingsChange: Flow<VolumeSettingsChange>
    suspend fun getIdfi(): String
    suspend fun getAuidString(): String?
    suspend fun getAuidByteString(): ByteString?
    val analyticsUserId: String?
    val ringerMode: Int
    val systemBootTime: Long
    val orientation: String
    val connectionTypeStr: String
    val currentUiTheme: Int
    val localeList: List<String>
    val appName: String
    val model: String
    val manufacturer: String
    val osVersion: String
    val hasInternet: Boolean
}