package com.unity3d.ads.core.data.manager

import android.content.Context
import com.unity3d.services.core.device.Storage


typealias LegacyStorageManager = com.unity3d.services.core.device.StorageManager

typealias LegacyStorageType = com.unity3d.services.core.device.StorageManager.StorageType

typealias LegacyStorage = com.unity3d.services.core.device.Storage


class AndroidStorageManager : StorageManager {
    override fun init(context: Context): Boolean = LegacyStorageManager.init(context)

    override fun initStorage(type: LegacyStorageType) = LegacyStorageManager.initStorage(type)

    override fun getStorage(type: LegacyStorageType): Storage = LegacyStorageManager.getStorage(type)

    override fun hasStorage(type: LegacyStorageType): Boolean = LegacyStorageManager.hasStorage(type)

    override fun addStorageLocation(type: LegacyStorageType, fileName: String) = LegacyStorageManager.addStorageLocation(type, fileName)

    override fun removeStorage(type: LegacyStorageType) = LegacyStorageManager.removeStorage(type)

    override fun hasInitialized() {
        getStorage(LegacyStorageType.PRIVATE).run {
            set(KEY_INITIALIZED, true)
            writeStorage()
        }
    }

    companion object {
        private const val KEY_INITIALIZED = "configuration.hasInitialized"
    }
}