/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import android.text.TextUtils;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.IJsonStorageReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonStorage
implements IJsonStorageReader {
    private JSONObject _data;

    public synchronized boolean initData() {
        if (this._data == null) {
            this._data = new JSONObject();
            return true;
        }
        return false;
    }

    public synchronized void setData(JSONObject data) {
        this._data = data;
    }

    @Override
    public synchronized JSONObject getData() {
        return this._data;
    }

    public synchronized boolean hasData() {
        return this._data != null && this._data.length() > 0;
    }

    public synchronized void clearData() {
        this._data = null;
    }

    public synchronized boolean set(String key, Object value) {
        if (this._data == null || key == null || key.length() == 0 || value == null) {
            DeviceLog.error("Storage not properly initialized or incorrect parameters:" + this._data + ", " + key + ", " + value);
            return false;
        }
        this.createObjectTree(this.getParentObjectTreeFor(key));
        if (this.findObject(this.getParentObjectTreeFor(key)) instanceof JSONObject) {
            JSONObject parentObject = (JSONObject)this.findObject(this.getParentObjectTreeFor(key));
            String[] objects = key.split("\\.");
            if (parentObject != null) {
                try {
                    parentObject.put(objects[objects.length - 1], value);
                }
                catch (JSONException e) {
                    DeviceLog.exception("Couldn't set value", (Exception)((Object)e));
                    return false;
                }
            }
        } else {
            DeviceLog.debug("Cannot set subvalue to an object that is not JSONObject");
            return false;
        }
        return true;
    }

    @Override
    public synchronized Object get(String key) {
        JSONObject parentObject;
        if (this._data == null) {
            DeviceLog.error("Data is NULL, readStorage probably not called");
            return null;
        }
        String[] objects = key.split("\\.");
        if (this.findObject(this.getParentObjectTreeFor(key)) instanceof JSONObject && (parentObject = (JSONObject)this.findObject(this.getParentObjectTreeFor(key))) != null) {
            Object o = null;
            try {
                if (parentObject.has(objects[objects.length - 1])) {
                    o = parentObject.get(objects[objects.length - 1]);
                }
            }
            catch (Exception e) {
                DeviceLog.exception("Error getting data", e);
            }
            return o;
        }
        return null;
    }

    public synchronized List<String> getKeys(String key, boolean recursive) {
        if (this.get(key) instanceof JSONObject) {
            JSONObject parentObject = (JSONObject)this.get(key);
            ArrayList<String> keys = new ArrayList<String>();
            if (parentObject != null) {
                Iterator i = parentObject.keys();
                while (i.hasNext()) {
                    String currentKey = (String)i.next();
                    List<String> subkeys = null;
                    if (recursive) {
                        subkeys = this.getKeys(key + "." + currentKey, recursive);
                    }
                    keys.add(currentKey);
                    if (subkeys == null) continue;
                    for (String subkey : subkeys) {
                        keys.add(currentKey + "." + subkey);
                    }
                }
            }
            return keys;
        }
        return null;
    }

    public synchronized boolean delete(String key) {
        JSONObject parentObject;
        if (this._data == null) {
            DeviceLog.error("Data is NULL, readStorage probably not called");
            return false;
        }
        String[] objects = key.split("\\.");
        return this.findObject(this.getParentObjectTreeFor(key)) instanceof JSONObject && (parentObject = (JSONObject)this.findObject(this.getParentObjectTreeFor(key))) != null && parentObject.remove(objects[objects.length - 1]) != null;
    }

    private synchronized Object findObject(String key) {
        String[] objects = key.split("\\.");
        JSONObject parentObject = this._data;
        if (key.length() == 0) {
            return parentObject;
        }
        for (int idx = 0; idx < objects.length; ++idx) {
            if (parentObject.has(objects[idx])) {
                try {
                    parentObject = parentObject.getJSONObject(objects[idx]);
                    continue;
                }
                catch (Exception e) {
                    DeviceLog.exception("Couldn't read JSONObject: " + objects[idx], e);
                    return null;
                }
            }
            return null;
        }
        return parentObject;
    }

    private synchronized void createObjectTree(String tree) {
        String[] objects = tree.split("\\.");
        JSONObject parentObject = this._data;
        if (tree.length() == 0) {
            return;
        }
        for (int idx = 0; idx < objects.length; ++idx) {
            if (!parentObject.has(objects[idx])) {
                try {
                    parentObject = parentObject.put(objects[idx], (Object)new JSONObject());
                    parentObject = parentObject.getJSONObject(objects[idx]);
                }
                catch (Exception e) {
                    DeviceLog.exception("Couldn't create new JSONObject", e);
                }
                continue;
            }
            try {
                parentObject = parentObject.getJSONObject(objects[idx]);
                continue;
            }
            catch (Exception e) {
                DeviceLog.exception("Couldn't get existing JSONObject", e);
            }
        }
    }

    private synchronized String getParentObjectTreeFor(String tree) {
        Object[] objects = tree.split("\\.");
        ArrayList<String> tmpObs = new ArrayList<String>(Arrays.asList(objects));
        tmpObs.remove(tmpObs.size() - 1);
        objects = tmpObs.toArray();
        String parentObject = TextUtils.join((CharSequence)".", (Object[])objects);
        return parentObject;
    }
}

