/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.unity3d.services.core.broadcast.BroadcastEvent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import org.json.JSONException;
import org.json.JSONObject;

public class BroadcastEventReceiver
extends BroadcastReceiver {
    private String _name;

    public BroadcastEventReceiver(String name) {
        this._name = name;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        String data = "";
        if (intent.getDataString() != null) {
            data = intent.getDataString();
        }
        JSONObject extras = new JSONObject();
        try {
            if (intent.getExtras() != null) {
                Bundle bundle = intent.getExtras();
                for (String key : bundle.keySet()) {
                    extras.put(key, bundle.get(key));
                }
            }
        }
        catch (JSONException e) {
            DeviceLog.debug("JSONException when composing extras for broadcast action " + action + ": " + e.getMessage());
        }
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp == null || !webViewApp.isWebAppLoaded()) {
            return;
        }
        webViewApp.sendEvent(WebViewEventCategory.BROADCAST, BroadcastEvent.ACTION, this._name, action, data, extras);
    }
}

