package com.unity3d.ads.core.extensions

import java.io.File

import java.util.LinkedList

fun File.getDirectorySize(): Long {
    if (!this.exists()) return 0
    if (!this.isDirectory) return this.length()
    val dirs: MutableList<File> = LinkedList()
    dirs.add(this)
    var result: Long = 0
    while (dirs.isNotEmpty()) {
        val dir = dirs.removeAt(0)
        if (!dir.exists()) continue
        val listFiles = dir.listFiles()
        if (listFiles == null || listFiles.isEmpty()) continue
        for (child in listFiles) {
            if (child.isDirectory) {
                dirs.add(child)
            } else {
                result += child.length()
            }
        }
    }
    return result
}