package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.MediationRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.UnityAdsConstants
import gatewayprotocol.v1.ClientInfoOuterClass
import gatewayprotocol.v1.UniversalRequestOuterClass.LimitedSessionToken
import gatewayprotocol.v1.limitedSessionToken



internal class GetAndroidLimitedSessionToken(
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val mediationRepository: MediationRepository
) : GetLimitedSessionToken {
    override suspend operator fun invoke(): LimitedSessionToken {
        return limitedSessionToken {
            sessionId = sessionRepository.sessionId
            deviceMake = deviceInfoRepository.staticDeviceInfo().deviceMake
            deviceModel = deviceInfoRepository.staticDeviceInfo().deviceModel
            osVersion = deviceInfoRepository.staticDeviceInfo().osVersion
            idfi = deviceInfoRepository.getIdfi()
            sdkVersion = UnityAdsConstants.ClientInfo.SDK_VERSION
            sdkVersionName = UnityAdsConstants.ClientInfo.SDK_VERSION_NAME
            gameId = sessionRepository.gameId
            platform = ClientInfoOuterClass.Platform.PLATFORM_ANDROID
            mediationProvider = mediationRepository.mediationProvider()
            mediationRepository.name?.let {
                if (mediationProvider == ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_CUSTOM) {
                    customMediationName = it
                }
            }
            mediationRepository.version?.let {
                mediationVersion = it
            }
        }
    }
}