/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.api;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.WindowInsets;
import com.unity3d.services.ads.adunit.AdUnitActivity;
import com.unity3d.services.ads.adunit.AdUnitError;
import com.unity3d.services.ads.adunit.AdUnitMotionEvent;
import com.unity3d.services.ads.adunit.AdUnitSoftwareActivity;
import com.unity3d.services.ads.adunit.AdUnitTransparentActivity;
import com.unity3d.services.ads.adunit.AdUnitTransparentSoftwareActivity;
import com.unity3d.services.ads.adunit.IAdUnitActivity;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdUnit {
    private static IAdUnitActivity _adUnitActivity;
    private static int _currentActivityId;

    private AdUnit() {
    }

    public static void setAdUnitActivity(IAdUnitActivity activity) {
        _adUnitActivity = activity;
    }

    public static IAdUnitActivity getAdUnitActivity() {
        return _adUnitActivity;
    }

    public static int getCurrentAdUnitActivityId() {
        return _currentActivityId;
    }

    public static void setCurrentAdUnitActivityId(int activityId) {
        _currentActivityId = activityId;
    }

    @WebViewExposed
    public static void open(Integer activityId, JSONArray views, Integer orientation, WebViewCallback callback) {
        AdUnit.open(activityId, views, orientation, null, callback);
    }

    @WebViewExposed
    public static void open(Integer activityId, JSONArray views, Integer orientation, JSONArray keyevents, WebViewCallback callback) {
        AdUnit.open(activityId, views, orientation, keyevents, 0, true, callback);
    }

    @WebViewExposed
    public static void open(Integer activityId, JSONArray views, Integer orientation, JSONArray keyevents, Integer systemUiVisibility, Boolean hardwareAcceleration, WebViewCallback callback) {
        AdUnit.open(activityId, views, orientation, keyevents, systemUiVisibility, hardwareAcceleration, false, callback);
    }

    @WebViewExposed
    public static void open(Integer activityId, JSONArray views, Integer orientation, JSONArray keyevents, Integer systemUiVisibility, Boolean hardwareAcceleration, Boolean isTransparent, WebViewCallback callback) {
        AdUnit.open(activityId, views, orientation, keyevents, systemUiVisibility, hardwareAcceleration, isTransparent, 0, callback);
    }

    @WebViewExposed
    public static void open(Integer activityId, JSONArray views, Integer orientation, JSONArray keyevents, Integer systemUiVisibility, Boolean hardwareAcceleration, Boolean isTransparent, Integer displayCutoutMode, WebViewCallback callback) {
        Intent intent;
        if (!hardwareAcceleration.booleanValue() && isTransparent.booleanValue()) {
            DeviceLog.debug("Unity Ads opening new transparent ad unit activity, hardware acceleration disabled");
            intent = new Intent((Context)ClientProperties.getActivity(), AdUnitTransparentSoftwareActivity.class);
        } else if (hardwareAcceleration.booleanValue() && !isTransparent.booleanValue()) {
            DeviceLog.debug("Unity Ads opening new hardware accelerated ad unit activity");
            intent = new Intent((Context)ClientProperties.getActivity(), AdUnitActivity.class);
        } else if (hardwareAcceleration.booleanValue() && isTransparent.booleanValue()) {
            DeviceLog.debug("Unity Ads opening new hardware accelerated transparent ad unit activity");
            intent = new Intent((Context)ClientProperties.getActivity(), AdUnitTransparentActivity.class);
        } else {
            DeviceLog.debug("Unity Ads opening new ad unit activity, hardware acceleration disabled");
            intent = new Intent((Context)ClientProperties.getActivity(), AdUnitSoftwareActivity.class);
        }
        int flags = 0x10010000;
        intent.addFlags(flags);
        if (activityId != null) {
            try {
                intent.putExtra("activityId", activityId.intValue());
            }
            catch (Exception e) {
                DeviceLog.exception("Could not set activityId for intent", e);
                callback.error(AdUnitError.ACTIVITY_ID, (int)activityId, e.getMessage());
                return;
            }
        } else {
            DeviceLog.error("Activity ID is NULL");
            callback.error(AdUnitError.ACTIVITY_ID, "Activity ID NULL");
            return;
        }
        AdUnit.setCurrentAdUnitActivityId(activityId);
        try {
            intent.putExtra("views", AdUnit.getViewList(views));
        }
        catch (Exception e) {
            DeviceLog.exception("Error parsing views from viewList", e);
            callback.error(AdUnitError.CORRUPTED_VIEWLIST, views, e.getMessage());
            return;
        }
        if (keyevents != null) {
            try {
                intent.putExtra("keyEvents", AdUnit.getKeyEventList(keyevents));
            }
            catch (Exception e) {
                DeviceLog.exception("Error parsing views from viewList", e);
                callback.error(AdUnitError.CORRUPTED_KEYEVENTLIST, keyevents, e.getMessage());
                return;
            }
        }
        intent.putExtra("systemUiVisibility", (Serializable)systemUiVisibility);
        intent.putExtra("orientation", (Serializable)orientation);
        intent.putExtra("displayCutoutMode", (Serializable)displayCutoutMode);
        ClientProperties.getActivity().startActivity(intent);
        DeviceLog.debug("Opened AdUnitActivity with: " + views.toString());
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void close(WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            AdUnit.getAdUnitActivity().finish();
            callback.invoke(new Object[0]);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setViews(final JSONArray views, WebViewCallback callback) {
        boolean corrupted = false;
        try {
            String[] viewList = AdUnit.getViewList(views);
        }
        catch (JSONException e) {
            callback.error(AdUnitError.CORRUPTED_VIEWLIST, views);
            corrupted = true;
        }
        if (!corrupted) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AdUnit.getAdUnitActivity() != null) {
                        try {
                            AdUnit.getAdUnitActivity().setViews(AdUnit.getViewList(views));
                        }
                        catch (Exception e) {
                            DeviceLog.exception("Corrupted viewlist", e);
                        }
                    }
                }
            });
        }
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(views);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getViews(WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            String[] views = AdUnit.getAdUnitActivity().getViews();
            callback.invoke(new JSONArray(Arrays.asList(views)));
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setOrientation(final Integer orientation, WebViewCallback callback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setOrientation(orientation);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(orientation);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getOrientation(WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(AdUnit.getAdUnitActivity().getRequestedOrientation());
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setKeepScreenOn(final Boolean screenOn, WebViewCallback callback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    boolean bl = AdUnit.getAdUnitActivity().setKeepScreenOn(screenOn);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setSystemUiVisibility(final Integer systemUiVisibility, WebViewCallback callback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setSystemUiVisibility(systemUiVisibility);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(systemUiVisibility);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setKeyEventList(JSONArray keyevents, WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            try {
                AdUnit.getAdUnitActivity().setKeyEventList(AdUnit.getKeyEventList(keyevents));
                callback.invoke(keyevents);
            }
            catch (Exception e) {
                DeviceLog.exception("Error parsing views from viewList", e);
                callback.error(AdUnitError.CORRUPTED_KEYEVENTLIST, keyevents, e.getMessage());
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setViewFrame(final String view, final Integer x, final Integer y, final Integer width, final Integer height, WebViewCallback callback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setViewFrame(view, x, y, width, height);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getViewFrame(String view, WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getViewFrame(view) != null) {
                Map<String, Integer> map2 = AdUnit.getAdUnitActivity().getViewFrame(view);
                callback.invoke(map2.get("x"), map2.get("y"), map2.get("width"), map2.get("height"));
            } else {
                callback.error(AdUnitError.UNKNOWN_VIEW, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void startMotionEventCapture(Integer maxEvents, WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().startCapture(maxEvents);
                callback.invoke(new Object[0]);
            } else {
                callback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void endMotionEventCapture(WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().endCapture();
                callback.invoke(new Object[0]);
            } else {
                callback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void clearMotionEventCapture(WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().clearCapture();
                callback.invoke(new Object[0]);
            } else {
                callback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getMotionEventCount(JSONArray eventTypes, WebViewCallback callback) {
        ArrayList<Integer> requestedEventTypes = new ArrayList<Integer>();
        for (int i = 0; i < eventTypes.length(); ++i) {
            try {
                requestedEventTypes.add(eventTypes.getInt(i));
                continue;
            }
            catch (Exception e) {
                DeviceLog.exception("Error retrieving int from eventTypes", e);
            }
        }
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                if (AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount() >= AdUnit.getAdUnitActivity().getLayout().getMaxEventCount()) {
                    callback.error(AdUnitError.MAX_MOTION_EVENT_COUNT_REACHED, new Object[0]);
                    return;
                }
                SparseIntArray counts = AdUnit.getAdUnitActivity().getLayout().getEventCount(requestedEventTypes);
                JSONObject retObj = new JSONObject();
                for (int i = 0; i < counts.size(); ++i) {
                    int key = counts.keyAt(i);
                    int value = counts.get(key);
                    try {
                        retObj.put(Integer.toString(key), value);
                        continue;
                    }
                    catch (Exception e) {
                        DeviceLog.exception("Error building response JSON", e);
                    }
                }
                callback.invoke(retObj);
            } else {
                callback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getMotionEventData(JSONObject infoIndices, WebViewCallback callback) {
        Iterator infoIterator = infoIndices.keys();
        SparseArray requestedInfos = new SparseArray();
        while (infoIterator.hasNext()) {
            String key = (String)infoIterator.next();
            int keyInt = Integer.parseInt(key);
            if (requestedInfos.get(keyInt) == null) {
                requestedInfos.put(keyInt, new ArrayList());
            }
            JSONArray keyIndices = null;
            try {
                keyIndices = infoIndices.getJSONArray(key);
            }
            catch (Exception e) {
                DeviceLog.exception("Couldn't fetch keyIndices", e);
            }
            if (keyIndices == null) continue;
            for (int i = 0; i < keyIndices.length(); ++i) {
                try {
                    ((ArrayList)requestedInfos.get(keyInt)).add(keyIndices.getInt(i));
                    continue;
                }
                catch (Exception e) {
                    DeviceLog.exception("Couldn't add value to requested infos", e);
                }
            }
        }
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                if (AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount() >= AdUnit.getAdUnitActivity().getLayout().getMaxEventCount()) {
                    callback.error(AdUnitError.MAX_MOTION_EVENT_COUNT_REACHED, new Object[0]);
                    return;
                }
                SparseArray<SparseArray<AdUnitMotionEvent>> eventInfos = AdUnit.getAdUnitActivity().getLayout().getEvents((SparseArray<ArrayList<Integer>>)requestedInfos);
                JSONObject infoObj = new JSONObject();
                for (int eventTypeIndex = 0; eventTypeIndex < eventInfos.size(); ++eventTypeIndex) {
                    int key = eventInfos.keyAt(eventTypeIndex);
                    SparseArray values = (SparseArray)eventInfos.get(key);
                    JSONObject typeObj = new JSONObject();
                    for (int motionEventIndex = 0; motionEventIndex < values.size(); ++motionEventIndex) {
                        JSONObject eventObj = new JSONObject();
                        int eventKey = values.keyAt(motionEventIndex);
                        AdUnitMotionEvent motionEvent = (AdUnitMotionEvent)values.get(eventKey);
                        try {
                            eventObj.put("action", motionEvent.getAction());
                            eventObj.put("isObscured", motionEvent.isObscured());
                            eventObj.put("toolType", motionEvent.getToolType());
                            eventObj.put("source", motionEvent.getSource());
                            eventObj.put("deviceId", motionEvent.getDeviceId());
                            eventObj.put("x", (double)motionEvent.getX());
                            eventObj.put("y", (double)motionEvent.getY());
                            eventObj.put("eventTime", motionEvent.getEventTime());
                            eventObj.put("pressure", (double)motionEvent.getPressure());
                            eventObj.put("size", (double)motionEvent.getSize());
                            typeObj.put(Integer.toString(eventKey), (Object)eventObj);
                            continue;
                        }
                        catch (Exception e) {
                            DeviceLog.debug("Couldn't construct event info", e);
                        }
                    }
                    try {
                        infoObj.put(Integer.toString(key), (Object)typeObj);
                        continue;
                    }
                    catch (Exception e) {
                        DeviceLog.debug("Couldn't construct info object", e);
                    }
                }
                callback.invoke(infoObj);
            } else {
                callback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getCurrentMotionEventCount(WebViewCallback callback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                callback.invoke(AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount());
            } else {
                callback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getSafeAreaInsets(WebViewCallback callback) {
        block11: {
            if (AdUnit.getAdUnitActivity() != null && AdUnit.getAdUnitActivity().getLayout() != null) {
                if (Build.VERSION.SDK_INT >= 28) {
                    WindowInsets windowInsets = AdUnit.getAdUnitActivity().getLayout().getRootWindowInsets();
                    if (windowInsets != null) {
                        JSONObject displayCutoutObject = new JSONObject();
                        try {
                            Method displayCutoutGetter = windowInsets.getClass().getMethod("getDisplayCutout", new Class[0]);
                            Object displayCutout = displayCutoutGetter.invoke((Object)windowInsets, new Object[0]);
                            if (displayCutout != null) {
                                Object safeInsetTop = displayCutout.getClass().getMethod("getSafeInsetTop", new Class[0]).invoke(displayCutout, new Object[0]);
                                Object safeInsetRight = displayCutout.getClass().getMethod("getSafeInsetRight", new Class[0]).invoke(displayCutout, new Object[0]);
                                Object safeInsetBottom = displayCutout.getClass().getMethod("getSafeInsetBottom", new Class[0]).invoke(displayCutout, new Object[0]);
                                Object safeInsetLeft = displayCutout.getClass().getMethod("getSafeInsetLeft", new Class[0]).invoke(displayCutout, new Object[0]);
                                displayCutoutObject.put("top", safeInsetTop);
                                displayCutoutObject.put("right", safeInsetRight);
                                displayCutoutObject.put("bottom", safeInsetBottom);
                                displayCutoutObject.put("left", safeInsetLeft);
                                callback.invoke(displayCutoutObject);
                                break block11;
                            }
                            callback.error(AdUnitError.NO_DISPLAY_CUTOUT_AVAILABLE, new Object[0]);
                        }
                        catch (NoSuchMethodException e) {
                            callback.error(AdUnitError.DISPLAY_CUTOUT_METHOD_NOT_AVAILABLE, new Object[0]);
                            DeviceLog.debug("Method getDisplayCutout not found", e);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            callback.error(AdUnitError.DISPLAY_CUTOUT_INVOKE_FAILED, new Object[0]);
                            DeviceLog.debug("Error while calling displayCutout getter", e);
                        }
                        catch (JSONException e) {
                            callback.error(AdUnitError.DISPLAY_CUTOUT_JSON_ERROR, new Object[0]);
                            DeviceLog.debug("JSON error while constructing display cutout object", new Object[]{e});
                        }
                    } else {
                        callback.error(AdUnitError.NO_DISPLAY_CUTOUT_AVAILABLE, new Object[0]);
                    }
                } else {
                    callback.error(AdUnitError.API_LEVEL_ERROR, new Object[0]);
                }
            } else {
                callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
            }
        }
    }

    @WebViewExposed
    public static void setLayoutInDisplayCutoutMode(final Integer displayCutoutMode, WebViewCallback callback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setLayoutInDisplayCutoutMode(displayCutoutMode);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            callback.invoke(displayCutoutMode);
        } else {
            callback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    private static String[] getViewList(JSONArray views) throws JSONException {
        String[] viewList = new String[views.length()];
        for (int viewidx = 0; viewidx < views.length(); ++viewidx) {
            viewList[viewidx] = views.getString(viewidx);
        }
        return viewList;
    }

    private static ArrayList<Integer> getKeyEventList(JSONArray keyevents) throws JSONException {
        ArrayList<Integer> keyEvents = new ArrayList<Integer>();
        Integer idx = 0;
        while (idx < keyevents.length()) {
            keyEvents.add(keyevents.getInt(idx.intValue()));
            Integer n = idx;
            idx = idx + 1;
        }
        return keyEvents;
    }

    static {
        _currentActivityId = -1;
    }
}

