package com.unity3d.ads.core.domain.work

import android.content.Context
import androidx.work.WorkerParameters
import com.unity3d.ads.core.domain.GetRequestPolicy
import com.unity3d.services.core.di.IServiceComponent
import com.unity3d.services.core.di.ServiceProvider
import com.unity3d.services.core.di.inject
import gateway.v1.UniversalRequestOuterClass

class DiagnosticEventJob(
    context: Context,
    workerParams: WorkerParameters
) : UniversalRequestJob(context, workerParams), IServiceComponent {

    private val getDiagnosticRequestPolicy: GetRequestPolicy by inject(ServiceProvider.NAMED_OTHER_REQ)
    private val diagnosticEventRequestWorkModifier: DiagnosticEventRequestWorkModifier by inject()

    override suspend fun doWork(): Result {
        val universalRequestId =
            workerParams.inputData.getString(UniversalRequestWorkerData.KEY_UNIVERSAL_REQUEST_ID)?: return Result.success()
        val rawUniversalRequest = universalRequestDataSource.get().getUniversalRequestMapOrThrow(universalRequestId)
        val universalRequest = UniversalRequestOuterClass.UniversalRequest.parseFrom(rawUniversalRequest)
        val modifiedUniversalRequest = diagnosticEventRequestWorkModifier(universalRequest)
        universalRequestDataSource.set(universalRequestId, modifiedUniversalRequest.toByteString())
        requestPolicy = getDiagnosticRequestPolicy()
        return super.doWork()
    }
}