package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.repository.DiagnosticEventRepository
import com.unity3d.ads.core.domain.events.GetDiagnosticEventRequest
import gateway.v1.DiagnosticEventRequestOuterClass.DiagnosticAdType.DIAGNOSTIC_AD_TYPE_UNSPECIFIED



internal class AndroidSendDiagnosticEvent(
    private val diagnosticEventRepository: DiagnosticEventRepository,
    private val getDiagnosticEventRequest: GetDiagnosticEventRequest,
) : SendDiagnosticEvent {
    override operator fun invoke(
        event: String,
        value: Double?,
        tags: Map<String, String>?,
        intTags: Map<String, Int>?,
        adObject: AdObject?,
    ) {
        val hb = adObject?.isHeaderBidding ?: false
        val opportunityId = adObject?.opportunityId ?: ByteString.EMPTY
        val placementId = adObject?.placementId ?: ""
        val adType = adObject?.adType ?: DIAGNOSTIC_AD_TYPE_UNSPECIFIED

        val diagnosticEventRequest = getDiagnosticEventRequest(event, tags, intTags, value, hb, opportunityId, placementId, adType)
        diagnosticEventRepository.addDiagnosticEvent(diagnosticEventRequest)
    }
}