/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.bridge.INativeCallbackSubject;
import com.unity3d.services.core.webview.bridge.IWebViewBridge;
import com.unity3d.services.core.webview.bridge.NativeCallback;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import com.unity3d.services.core.webview.bridge.WebViewBridgeError;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;

public class WebViewBridge
implements IWebViewBridge {
    private static IWebViewBridge _instance;
    private final INativeCallbackSubject nativeCallbackSubject;
    private HashMap<String, HashMap<String, HashMap<Integer, Method>>> _classTable;

    public static void setClassTable(Class[] apiClassList) {
        _instance = new WebViewBridge(apiClassList, SharedInstances.INSTANCE.getWebViewAppNativeCallbackSubject());
    }

    public static IWebViewBridge getInstance() {
        return _instance;
    }

    private WebViewBridge(Class[] apiClassList, INativeCallbackSubject nativeCallbackSubject) {
        this.nativeCallbackSubject = nativeCallbackSubject;
        if (apiClassList == null) {
            return;
        }
        this._classTable = new HashMap();
        for (Class cls : apiClassList) {
            if (cls == null || !cls.getPackage().getName().startsWith("com.unity3d.services") && !cls.getPackage().getName().startsWith("com.unity3d.ads.test")) continue;
            HashMap<String, HashMap> methodTable = new HashMap<String, HashMap>();
            for (Method method : cls.getMethods()) {
                if (method.getAnnotation(WebViewExposed.class) == null) continue;
                String methodName = method.getName();
                HashMap overrideTable = methodTable.containsKey(methodName) ? (HashMap)methodTable.get(methodName) : new HashMap();
                overrideTable.put(Arrays.deepHashCode(method.getParameterTypes()), method);
                methodTable.put(methodName, overrideTable);
            }
            this._classTable.put(cls.getName(), methodTable);
        }
    }

    private Method findMethod(String className, String methodName, Object[] parameters) throws JSONException, NoSuchMethodException {
        if (!this._classTable.containsKey(className)) {
            throw new NoSuchMethodException();
        }
        HashMap<String, HashMap<Integer, Method>> methodTable = this._classTable.get(className);
        if (!methodTable.containsKey(methodName)) {
            throw new NoSuchMethodException();
        }
        HashMap<Integer, Method> overrideTable = methodTable.get(methodName);
        Object[] types = this.getTypes(parameters);
        return overrideTable.get(Arrays.deepHashCode(types));
    }

    private Class<?>[] getTypes(Object[] parameters) throws JSONException {
        Class[] types = parameters == null ? new Class[1] : new Class[parameters.length + 1];
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                types[i] = parameters[i].getClass();
            }
        }
        types[types.length - 1] = WebViewCallback.class;
        return types;
    }

    private Object[] getValues(Object[] parameters, WebViewCallback callback) throws JSONException {
        Object[] values;
        if (parameters == null) {
            if (callback == null) {
                return null;
            }
            values = new Object[1];
        } else {
            values = new Object[parameters.length + (callback != null ? 1 : 0)];
        }
        if (parameters != null) {
            System.arraycopy(parameters, 0, values, 0, parameters.length);
        }
        if (callback != null) {
            values[values.length - 1] = callback;
        }
        return values;
    }

    @Override
    public void handleInvocation(String className, String methodName, Object[] parameters, WebViewCallback callback) throws Exception {
        Method method;
        try {
            method = this.findMethod(className, methodName, parameters);
        }
        catch (NoSuchMethodException | JSONException e) {
            callback.error(WebViewBridgeError.METHOD_NOT_FOUND, className, methodName, parameters);
            throw e;
        }
        try {
            Object[] values = this.getValues(parameters, callback);
            method.invoke(null, values);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JSONException e) {
            if (callback != null) {
                callback.error(WebViewBridgeError.INVOCATION_FAILED, className, methodName, parameters, e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void handleCallback(String callbackId, String callbackStatus, Object[] parameters) throws Exception {
        NativeCallback callback = this.nativeCallbackSubject.getCallback(callbackId);
        try {
            callback.invoke(callbackStatus, this.getValues(parameters, null));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JSONException e) {
            DeviceLog.error("Error while invoking method");
            throw e;
        }
    }
}

