/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request;

import android.os.Bundle;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.IWebRequestListener;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebRequestRunnable
implements Runnable {
    private WebRequest _currentRequest;
    private boolean _canceled = false;
    private final String _url;
    private final String _type;
    private final String _body;
    private final int _connectTimeout;
    private final int _readTimeout;
    private final Map<String, List<String>> _headers;
    private final IWebRequestListener _listener;

    public WebRequestRunnable(String url, String type, String body, int connectTimeout, int readTimeout, Map<String, List<String>> headers, IWebRequestListener listener2) {
        this._url = url;
        this._type = type;
        this._body = body;
        this._connectTimeout = connectTimeout;
        this._readTimeout = readTimeout;
        this._headers = headers;
        this._listener = listener2;
    }

    @Override
    public void run() {
        DeviceLog.debug("Handling request message: " + this._url + " type=" + this._type);
        try {
            this.makeRequest(this._url, this._type, this._headers, this._body, this._connectTimeout, this._readTimeout);
        }
        catch (MalformedURLException e) {
            DeviceLog.exception("Malformed URL", e);
            this.onFailed("Malformed URL");
        }
        catch (Error e) {
            DeviceLog.error("Out of memory error while doing web request.");
            SDKMetricsSender sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
            sdkMetricsSender.sendEvent("native_webview_oom", null, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("src", "WebRequestRunnable");
                    this.put("url", WebRequestRunnable.this._url);
                    this.put("type", WebRequestRunnable.this._type);
                }
            });
            this.onFailed("Out of memory error while doing web request.");
        }
    }

    public void setCancelStatus(boolean canceled) {
        this._canceled = canceled;
        if (this._canceled && this._currentRequest != null) {
            this._currentRequest.cancel();
        }
    }

    private void makeRequest(String url, String type, Map<String, List<String>> headers, String body, int connectTimeout, int readTimeout) throws MalformedURLException {
        String response;
        if (this._canceled) {
            return;
        }
        this._currentRequest = new WebRequest(url, type, headers, connectTimeout, readTimeout);
        if (body != null) {
            this._currentRequest.setBody(body);
        }
        try {
            response = this._currentRequest.makeRequest();
        }
        catch (Exception e) {
            DeviceLog.exception("Error completing request", e);
            this.onFailed(e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        if (this._currentRequest.isCanceled()) {
            return;
        }
        Bundle data = new Bundle();
        Map<String, List<String>> responseHeaders = this._currentRequest.getResponseHeaders();
        if (responseHeaders != null) {
            for (String key : responseHeaders.keySet()) {
                if (key == null || key.contentEquals("null")) continue;
                String[] values = new String[responseHeaders.get(key).size()];
                for (int valueidx = 0; valueidx < responseHeaders.get(key).size(); ++valueidx) {
                    values[valueidx] = responseHeaders.get(key).get(valueidx);
                }
                data.putStringArray(key, values);
            }
        }
        if (this._currentRequest.isCanceled()) {
            return;
        }
        this.onSucceed(response, this._currentRequest.getResponseCode(), this.getResponseHeaders(data));
    }

    private void onSucceed(String response, int responseCode, Map<String, List<String>> headers) {
        this._listener.onComplete(this._url, response, responseCode, headers);
    }

    private void onFailed(String error2) {
        this._listener.onFailed(this._url, error2);
    }

    private Map<String, List<String>> getResponseHeaders(Bundle resultData) {
        HashMap<String, ArrayList<String>> responseHeaders = null;
        if (!resultData.isEmpty()) {
            responseHeaders = new HashMap<String, ArrayList<String>>();
            for (String k : resultData.keySet()) {
                String[] tmpAr = resultData.getStringArray(k);
                if (tmpAr == null) continue;
                responseHeaders.put(k, new ArrayList<String>(Arrays.asList(tmpAr)));
            }
        }
        return responseHeaders;
    }
}

