/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.domain;

import android.content.Context;
import android.net.Uri;
import android.webkit.WebResourceResponse;
import com.unity3d.ads.adplayer.GetWebViewAssetLoaderKt;
import com.unity3d.ads.core.data.model.CacheResult;
import com.unity3d.ads.core.data.repository.CacheRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;

@Single
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0013\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unity3d/ads/core/domain/GetCachedAsset;", "", "cacheRepository", "Lcom/unity3d/ads/core/data/repository/CacheRepository;", "context", "Landroid/content/Context;", "(Lcom/unity3d/ads/core/data/repository/CacheRepository;Landroid/content/Context;)V", "getBundledAsset", "Landroid/webkit/WebResourceResponse;", "uri", "Landroid/net/Uri;", "getCachedAsset", "invoke", "unity-ads_release"})
public final class GetCachedAsset {
    @NotNull
    private final CacheRepository cacheRepository;
    @NotNull
    private final Context context;

    public GetCachedAsset(@NotNull CacheRepository cacheRepository, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)cacheRepository, (String)"cacheRepository");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.cacheRepository = cacheRepository;
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final WebResourceResponse invoke(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getHost();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -1920242293: {
                if (string.equals("unity.ads.cache")) {
                    n = 1;
                }
                break;
            }
            case -1921537799: {
                if (string.equals("unity.ads.asset")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                WebResourceResponse webResourceResponse = this.getCachedAsset(uri);
                return webResourceResponse;
            }
            case 2: {
                WebResourceResponse webResourceResponse = this.getBundledAsset(uri);
                return webResourceResponse;
            }
            default: {
                return null;
            }
        }
    }

    private final WebResourceResponse getBundledAsset(Uri uri) {
        WebResourceResponse webResourceResponse;
        String fileName = StringsKt.substringAfter$default((String)String.valueOf(uri.getPath()), (String)"/", null, (int)2, null);
        try {
            InputStream inputStream = this.context.getAssets().open(fileName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(fileName)");
            InputStream inputStream2 = inputStream;
            webResourceResponse = new WebResourceResponse(GetWebViewAssetLoaderKt.guessMimeType(fileName), null, inputStream2);
        }
        catch (Exception e) {
            webResourceResponse = null;
        }
        return webResourceResponse;
    }

    private final WebResourceResponse getCachedAsset(Uri uri) {
        WebResourceResponse webResourceResponse;
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        String urlString = string;
        String file = StringsKt.substringAfterLast$default((String)urlString, (String)"/", null, (int)2, null);
        String fileName = StringsKt.substringBeforeLast$default((String)file, (String)".", null, (int)2, null);
        CacheResult result = this.cacheRepository.retrieveFile(fileName);
        if (result instanceof CacheResult.Success) {
            File file2 = ((CacheResult.Success)result).getCachedFile().getFile();
            if (file2 == null) {
                return null;
            }
            File rawFile = file2;
            FileInputStream fileInputStream = new FileInputStream(rawFile);
            String filePath = rawFile.getAbsolutePath() + '.' + ((CacheResult.Success)result).getCachedFile().getExtension();
            webResourceResponse = new WebResourceResponse(GetWebViewAssetLoaderKt.guessMimeType(filePath), null, (InputStream)fileInputStream);
        } else {
            webResourceResponse = null;
        }
        return webResourceResponse;
    }
}

