package com.unity3d.services.core.di

/**
 * Main service provider containing and instantiating required dependencies
 */
object ServiceProvider {

    const val NAMED_SDK: String = "sdk"
    const val NAMED_INIT_SCOPE: String = "init_scope"
    const val NAMED_LOAD_SCOPE: String = "load_scope"
    const val NAMED_SHOW_SCOPE: String = "show_scope"
    const val NAMED_GET_TOKEN_SCOPE: String = "get_token_scope"
    const val NAMED_TRANSACTION_SCOPE: String = "transaction_scope"
    const val NAMED_OMID_SCOPE: String = "omid_scope"
    const val NAMED_INIT_REQ: String = "init_req"
    const val NAMED_OPERATIVE_REQ: String = "op_event_req"
    const val NAMED_OTHER_REQ: String = "other_req"
    const val NAMED_AD_REQ: String = "ad_req"
    const val NAMED_PUBLIC_JOB: String = "public_job"
    const val NAMED_LOCAL: String = "local"
    const val NAMED_REMOTE: String = "remote"

    const val LEGACY_PRIVACY_RULES = "legacy_privacy_rules"
    const val DEV_CONSENT_PRIVACY_RULES = "dev_consent_privacy_rules"

    // datastores
    const val DATA_STORE_GATEWAY_CACHE = "gateway_cache.pb"
    const val DATA_STORE_PRIVACY = "privacy.pb"
    const val DATA_STORE_IDFI = "idfi.pb"
    const val DATA_STORE_AUID = "auid.pb"
    const val DATA_STORE_PRIVACY_FSM = "privacy_fsm.pb"
    const val DATA_STORE_NATIVE_CONFIG = "native_configuration.pb"
    const val DATA_STORE_IAP_TRANSACTION = "iap_transaction.pb"
    const val DATA_STORE_UNIVERSAL_REQUEST = "universal_request.pb"
    const val DATA_STORE_GL_INFO = "glinfo.pb"
    const val DATA_STORE_WEBVIEW_CONFIG = "webview_config.pb"

    // preferences
    const val PREF_IDFI = "unityads-installinfo"
    const val PREF_AUID = "supersonic_shared_preferen"
    const val PREF_DEFAULT = "default-migration"
    const val PREF_GL_INFO = "glinfo"

    // http
    const val GATEWAY_HOST = "gateway.unityads.unity3d.com"
    const val GATEWAY_PORT = 443
    const val CDN_CREATIVES_HOST = "cdn-creatives-cf-prd.acquire.unity3dusercontent.com"
    const val CDN_CREATIVES_PORT = 443
    const val HTTP_CACHE_DISK_SIZE = 5 * 1024 * 1024L // 5MiB
    const val HTTP_CLIENT_FETCH_TIMEOUT = 500L // 500ms

    const val MAIN_DISPATCHER = "main_dispatcher"
    const val DEFAULT_DISPATCHER = "default_dispatcher"
    const val IO_DISPATCHER = "io_dispatcher"
}
