package com.unity3d.ads.core.extensions

import gateway.v1.TransactionEventRequestOuterClass.TransactionState
import gateway.v1.TransactionEventRequestOuterClass.TransactionState.TRANSACTION_STATE_UNSPECIFIED
import gateway.v1.TransactionEventRequestOuterClass.TransactionState.TRANSACTION_STATE_PURCHASED
import gateway.v1.TransactionEventRequestOuterClass.TransactionState.TRANSACTION_STATE_PENDING
import gateway.v1.TransactionEventRequestOuterClass.TransactionState.UNRECOGNIZED

fun fromPurchaseState(state: Int): TransactionState = when (state) {
    // Note: https://github.com/android/play-billing-samples/issues/227
    // https://developers.google.com/android-publisher/api-ref/rest/v3/purchases.products
    0 -> TRANSACTION_STATE_PURCHASED
    1 -> TRANSACTION_STATE_UNSPECIFIED
    2 -> TRANSACTION_STATE_PENDING
    else -> UNRECOGNIZED
}