package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import gateway.v1.UniversalRequestKt.payload
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.privacyUpdateRequest
import org.koin.core.annotation.Single

@Single
class GetPrivacyUpdateRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad
) {
    suspend operator fun invoke(
        privacyUpdateVersion: Int,
        privacyUpdateContent: ByteString
    ): UniversalRequest {
        val request = privacyUpdateRequest {
            version = privacyUpdateVersion
            content = privacyUpdateContent
        }

        val privacyPayLoad = payload {
            privacyUpdateRequest = request
        }

        return getUniversalRequestForPayLoad(privacyPayLoad)
    }
}