package com.unity3d.ads.core.domain

import android.opengl.GLES20
import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gl.EglCore
import com.unity3d.ads.gl.OffscreenSurface
import org.koin.core.annotation.Single

@Single
internal class GetAndroidOpenGLRendererInfo(private val sessionRepository: SessionRepository) : GetOpenGLRendererInfo {
    override fun invoke(): ByteString {
        val openglGpuEnabled = sessionRepository.featureFlags.openglGpuEnabled
        return if (openglGpuEnabled) {
            // We need a GL context to examine, so create one and make it current, which means we need an EGL surface.
            // Create a 1x1 pbuffer.
            val eglCore = EglCore(null, EglCore.FLAG_TRY_GLES3)
            val surface = OffscreenSurface(eglCore, 1, 1)
            surface.makeCurrent()

            val renderer = GLES20.glGetString(GLES20.GL_RENDERER)
            val rendererByteString = ByteString.copyFrom(renderer.toByteArray(Charsets.ISO_8859_1))

            surface.release()
            eglCore.release()

            rendererByteString
        } else {
            ByteString.empty()
        }
    }
}