package com.unity3d.ads.core.data.datasource

import android.content.Context
import com.unity3d.ads.core.extensions.toByteString
import com.unity3d.services.core.device.AdvertisingId
import com.unity3d.services.core.device.OpenAdvertisingId
import gateway.v1.AllowedPiiOuterClass.AllowedPii
import gateway.v1.PiiOuterClass
import gateway.v1.pii
import kotlinx.coroutines.flow.MutableStateFlow
import org.koin.core.annotation.Single
import java.util.UUID

@Single
class AndroidPrivacyDeviceInfoDataSource(
    private val context: Context
) : PrivacyDeviceInfoDataSource {
    private val idfaInitialized = MutableStateFlow(false)

    override fun fetch(allowed: AllowedPii): PiiOuterClass.Pii {
        // Initialize only once, this is not done in init block for now since underlying service binder is doing callbacks on the main thread.
        if (!idfaInitialized.value) {
            idfaInitialized.value = true
            AdvertisingId.init(context)
            OpenAdvertisingId.init(context)

        }
        return pii {
            if (allowed.idfa) {
                val adId = getAdvertisingTrackingId()
                if (adId.isNotEmpty()) advertisingId = UUID.fromString(adId).toByteString()
                val openAdId = getOpenAdvertisingTrackingId()
                if (openAdId.isNotEmpty()) openAdvertisingTrackingId = UUID.fromString(openAdId).toByteString()
            }
        }
    }

    private fun getAdvertisingTrackingId(): String {
        return AdvertisingId.getAdvertisingTrackingId() ?: ""
    }

    private fun getOpenAdvertisingTrackingId(): String {
        return OpenAdvertisingId.getOpenAdvertisingTrackingId() ?: ""
    }
}