package com.unity3d.ads.core.data.datasource

import com.unity3d.ads.core.domain.privacy.FlattenerRulesUseCase
import com.unity3d.services.core.di.ServiceProvider.LEGACY_PRIVACY_RULES
import com.unity3d.services.core.misc.JsonFlattener
import com.unity3d.services.core.misc.JsonStorage
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
class AndroidLegacyUserConsentDataSource(
    @Named(LEGACY_PRIVACY_RULES) private val flattenerRulesUseCase: FlattenerRulesUseCase,
    @Named("PRIVATE") private val privateStorage: JsonStorage,
) : LegacyUserConsentDataSource {
    override val privacyData: String?
        get(): String? {
            privateStorage.data?.let {
                val flattener = JsonFlattener(it)
                return flattener.flattenJson(".", flattenerRulesUseCase())?.toString()
            }?: return null
        }
}