package com.unity3d.ads.adplayer

import com.unity3d.services.core.di.KoinModule
import com.unity3d.services.core.di.ServiceProvider.DEFAULT_DISPATCHER
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.job
import org.koin.core.annotation.Factory
import org.koin.core.annotation.Named
import org.koin.core.component.KoinScopeComponent

@Factory
class AdPlayerScope(
    @Named(DEFAULT_DISPATCHER)
    private val defaultDispatcher: CoroutineDispatcher,
) : KoinScopeComponent, CoroutineScope by CoroutineScope(defaultDispatcher) {
    override val scope = KoinModule.system.koin.createScope<AdPlayerScope>()

    init {
        coroutineContext.job.invokeOnCompletion {
            scope.close()
        }
    }
}