/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.unity3d.services.core.di.KoinModule;
import com.unity3d.services.core.log.DeviceLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.JvmClassMappingKt;
import org.json.JSONException;
import org.json.JSONObject;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.qualifier.StringQualifier;

public class Utilities {
    public static void runOnUiThread(Runnable runnable) {
        Utilities.runOnUiThread(runnable, 0L);
    }

    public static void runOnUiThread(Runnable runnable, long delay) {
        Handler handler = new Handler(Looper.getMainLooper());
        if (delay > 0L) {
            handler.postDelayed(runnable, delay);
        } else {
            handler.post(runnable);
        }
    }

    public static String Sha256(String input) {
        return Utilities.Sha256(input.getBytes());
    }

    public static String Sha256(byte[] input) {
        MessageDigest m;
        if (input == null) {
            return null;
        }
        try {
            m = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            DeviceLog.exception("SHA-256 algorithm not found", e);
            return null;
        }
        m.update(input, 0, input.length);
        return Utilities.toHexString(m.digest());
    }

    public static String Sha256(InputStream inputStream) throws IOException {
        int read;
        MessageDigest m;
        if (inputStream == null) {
            return null;
        }
        try {
            m = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            DeviceLog.exception("SHA-256 algorithm not found", e);
            return null;
        }
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            m.update(buffer, 0, read);
        }
        return Utilities.toHexString(m.digest());
    }

    public static String toHexString(byte[] array) {
        String output = "";
        for (byte rawByte : array) {
            int b = 0xFF & rawByte;
            if (b <= 15) {
                output = output + "0";
            }
            output = output + Integer.toHexString(b);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(File fileToWrite, String content) {
        if (fileToWrite == null) {
            return false;
        }
        FileOutputStream fos = null;
        boolean success2 = true;
        try {
            fos = new FileOutputStream(fileToWrite);
            fos.write(content.getBytes());
            fos.flush();
        }
        catch (Exception e) {
            success2 = false;
            DeviceLog.exception("Could not write file", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                DeviceLog.exception("Error closing FileOutputStream", e);
            }
        }
        if (success2) {
            DeviceLog.debug("Wrote file: " + fileToWrite.getAbsolutePath());
        }
        return success2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(File file) throws IOException {
        byte[] buffer;
        if (file == null || !file.exists()) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Files.readAllBytes(file.toPath());
        }
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            buffer = new byte[(int)file.length()];
            int readBytes = ((InputStream)inputStream).read(buffer);
            if (readBytes != buffer.length) {
                throw new IOException("Failed to read all bytes from input file path: " + file.getPath());
            }
        }
        return buffer;
    }

    public static JSONObject mergeJsonObjects(JSONObject primary, JSONObject secondary) throws JSONException {
        String key;
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        JSONObject newJsonObject = new JSONObject();
        Iterator keys = secondary.keys();
        while (keys.hasNext()) {
            key = (String)keys.next();
            newJsonObject.put(key, secondary.get(key));
        }
        keys = primary.keys();
        while (keys.hasNext()) {
            key = (String)keys.next();
            if (newJsonObject.has(key) && newJsonObject.get(key) instanceof JSONObject && primary.get(key) instanceof JSONObject) {
                newJsonObject.put(key, (Object)Utilities.mergeJsonObjects(primary.getJSONObject(key), newJsonObject.getJSONObject(key)));
                continue;
            }
            newJsonObject.put(key, primary.get(key));
        }
        return newJsonObject;
    }

    public static Map<String, Object> combineJsonIntoMap(Map<String, Object> outputMap, JSONObject jsonObject, String prependToKey) {
        HashMap<String, Object> combinedMap = new HashMap<String, Object>(outputMap);
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            combinedMap.put(prependToKey + key, jsonObject.opt(key));
        }
        return combinedMap;
    }

    public static Map<String, Object> combineJsonIntoMap(Map<String, Object> inputMap, JSONObject jsonObject) {
        return Utilities.combineJsonIntoMap(inputMap, jsonObject, "");
    }

    public static Map<String, Object> convertJsonToMap(JSONObject jsonObject) {
        return Utilities.combineJsonIntoMap(new HashMap<String, Object>(), jsonObject);
    }

    public static <T> T getService(String name, Class clazz) {
        StringQualifier serviceName = name.isEmpty() ? null : QualifierKt.named((String)name);
        return (T)KoinModule.Companion.getSystem().getKoin().get(JvmClassMappingKt.getKotlinClass((Class)clazz), (Qualifier)serviceName, null);
    }

    public static <T> T getService(Class clazz) {
        return Utilities.getService("", clazz);
    }

    public static void wrapCustomerListener(Runnable listener2) {
        try {
            listener2.run();
        }
        catch (Exception exception) {
            DeviceLog.error("An uncaught exception has occurred in the client application.  Exception: %s", exception.getMessage());
        }
    }
}

