/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.webview.WebViewApp;
import java.io.File;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.koin.core.annotation.Single;

@Single
public class ConfigurationReader {
    private Configuration _localConfiguration;

    public Configuration getCurrentConfiguration() {
        if (this.getRemoteConfiguration() != null) {
            return this.getRemoteConfiguration();
        }
        Configuration localConfig = this.getLocalConfiguration();
        return localConfig != null ? localConfig : new Configuration();
    }

    private Configuration getRemoteConfiguration() {
        if (WebViewApp.getCurrentApp() == null) {
            return null;
        }
        return WebViewApp.getCurrentApp().getConfiguration();
    }

    private Configuration getLocalConfiguration() {
        if (this._localConfiguration != null) {
            return this._localConfiguration;
        }
        File configFile = new File(SdkProperties.getLocalConfigurationFilepath());
        if (configFile.exists()) {
            try {
                String fileContent = new String(Utilities.readFileBytes(configFile));
                JSONObject loadedJson = new JSONObject(fileContent);
                this._localConfiguration = new Configuration(loadedJson);
            }
            catch (IOException | JSONException exception) {
                DeviceLog.debug("Unable to read configuration from storage");
                this._localConfiguration = null;
            }
        }
        return this._localConfiguration;
    }
}

