package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import gateway.v1.TransactionEventRequestOuterClass
import gateway.v1.transactionEventRequest
import org.koin.core.annotation.Single

@Single
internal class GetCommonTransactionRequest(
    private val deviceInfoRepository: DeviceInfoRepository
): GetTransactionRequest {
    override suspend operator fun invoke(transactionDataList: List<TransactionEventRequestOuterClass.TransactionData>): TransactionEventRequestOuterClass.TransactionEventRequest {
        return transactionEventRequest {
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            appStore = TransactionEventRequestOuterClass.StoreType.STORE_TYPE_GOOGLE_PLAY
            transactionData.addAll(
                transactionDataList
            )
        }
    }
}