package com.unity3d.ads.core.data.datasource

import com.google.protobuf.ByteString
import com.unity3d.ads.core.extensions.toByteString
import java.util.UUID

class GetIdfiData: GetByteStringData, GetPreferenceString {
    override fun invoke(data: String): ByteString {
        return UUID.fromString(data).toByteString()
    }

    override fun invoke(): String {
        return UUID.randomUUID().toString()
    }
}