package com.unity3d.ads.core.domain.om

import android.webkit.WebView
import com.iab.omid.library.unity3d.adsession.CreativeType
import com.iab.omid.library.unity3d.adsession.ImpressionType
import com.iab.omid.library.unity3d.adsession.Owner
import com.unity3d.ads.adplayer.AndroidEmbeddableWebViewAdPlayer
import com.unity3d.ads.adplayer.AndroidFullscreenWebViewAdPlayer
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_CREATIVE_TYPE
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_CUSTOM_REFERENCE_DATA
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_IMPRESSION_OWNER
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_ISOLATE_VERIFICATION_SCRIPTS
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_MEDIA_EVENTS_OWNER
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_VIDEO_EVENTS_OWNER
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.OmidOptions
import org.json.JSONObject

abstract class CommonOmInteraction : OmInteraction {
    override fun getWebview(adObject: AdObject): WebView? {
        return when (val adPLayer = adObject.adPlayer) {
            is AndroidFullscreenWebViewAdPlayer -> adPLayer.webViewContainer.webView
            is AndroidEmbeddableWebViewAdPlayer -> adPLayer.webViewContainer.webView
            else -> null
        }
    }

    override fun getOMidOptions(options: JSONObject): OmidOptions {
        return OmidOptions(
            isolateVerificationScripts = options.optBoolean(OMID_ISOLATE_VERIFICATION_SCRIPTS),
            impressionOwner = getImpressionsOwner(options),
            videoEventsOwner = getVideoEventsOwner(options),
            customReferenceData = options.optString(OMID_CUSTOM_REFERENCE_DATA),
            impressionType = getImpressionType(options),
            creativeType = getCreativeType(options),
            mediaEventsOwner = getMediaEventsOwner(options),
        )
    }

    private fun getImpressionType(options: JSONObject): ImpressionType {
        return ImpressionType.valueOf(options.optString(OmInteraction.OMID_IMPRESSION_TYPE))
    }

    private fun getCreativeType(options: JSONObject): CreativeType {
        return CreativeType.valueOf(options.optString(OMID_CREATIVE_TYPE))
    }

    private fun getVideoEventsOwner(options: JSONObject): Owner {
        return try {
            Owner.valueOf(options.optString(OMID_VIDEO_EVENTS_OWNER))
        } catch (t: IllegalArgumentException) {
            Owner.NONE
        }
    }

    private fun getMediaEventsOwner(options: JSONObject): Owner {
        return try {
            Owner.valueOf(options.optString(OMID_MEDIA_EVENTS_OWNER))
        } catch (t: IllegalArgumentException) {
            Owner.NONE
        }
    }

    private fun getImpressionsOwner(options: JSONObject): Owner {
        return try {
            Owner.valueOf(options.optString(OMID_IMPRESSION_OWNER))
        } catch (t: IllegalArgumentException) {
            Owner.NONE
        }
    }
}