package com.unity3d.ads.core.data.manager

import android.content.Context
import android.webkit.WebView
import com.iab.omid.library.unity3d.adsession.AdEvents
import com.iab.omid.library.unity3d.adsession.AdSession
import com.iab.omid.library.unity3d.adsession.AdSessionConfiguration
import com.iab.omid.library.unity3d.adsession.AdSessionContext
import com.iab.omid.library.unity3d.adsession.CreativeType
import com.iab.omid.library.unity3d.adsession.ImpressionType
import com.iab.omid.library.unity3d.adsession.Owner
import com.iab.omid.library.unity3d.adsession.Partner

interface OmidManager {
    val isActive: Boolean
    val version: String
    fun activate(context: Context)
    fun createHtmlAdSessionContext(partner: Partner?, adView: WebView?, contentUrl: String?, customReferenceData: String?): AdSessionContext
    fun createAdSessionConfiguration(creativeType: CreativeType, impressionType: ImpressionType, owner: Owner, mediaEventsOwner: Owner, isolateVerificationScripts: Boolean): AdSessionConfiguration
    fun createAdSession(adSessionConfiguration: AdSessionConfiguration, context: AdSessionContext): AdSession
    fun createAdEvents(adSession: AdSession): AdEvents
}