/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge.invocation;

import android.os.ConditionVariable;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import java.lang.reflect.Method;

public class WebViewBridgeInvocationRunnable
implements Runnable {
    private static ConditionVariable _responseTimeout;
    private static CallbackStatus _callbackStatus;
    private IWebViewBridgeInvocationCallback _invocationCallback;
    private IWebViewBridgeInvoker _webViewBridgeInvoker;
    private Method _webViewBridgeCallbackMethod;
    private String _className;
    private String _methodName;
    private int _timeoutLengthInMilliSeconds;
    private Object[] _invocationParameters;

    public WebViewBridgeInvocationRunnable(IWebViewBridgeInvocationCallback invocationCallback, IWebViewBridgeInvoker webViewBridgeInvoker, String className, String methodName, int timeoutLengthInMilliSeconds, Object ... invocationParameters) {
        try {
            this._webViewBridgeCallbackMethod = WebViewBridgeInvocationRunnable.class.getMethod("onInvocationComplete", CallbackStatus.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("WebViewBridgeInvocation callback method cannot be found", e);
        }
        this._invocationCallback = invocationCallback;
        this._webViewBridgeInvoker = webViewBridgeInvoker;
        this._className = className;
        this._methodName = methodName;
        this._timeoutLengthInMilliSeconds = timeoutLengthInMilliSeconds;
        this._invocationParameters = invocationParameters;
    }

    @Override
    public void run() {
        _callbackStatus = null;
        _responseTimeout = new ConditionVariable();
        boolean invokeMethodSuccess = this._webViewBridgeInvoker.invokeMethod(this._className, this._methodName, this._webViewBridgeCallbackMethod, this._invocationParameters);
        if (this._invocationCallback == null) {
            return;
        }
        if (!invokeMethodSuccess) {
            this._invocationCallback.onFailure("WebViewBridgeInvocationRunnable:run: invokeMethod failure", null);
            return;
        }
        if (_responseTimeout.block((long)this._timeoutLengthInMilliSeconds)) {
            if (_callbackStatus == CallbackStatus.OK) {
                this._invocationCallback.onSuccess();
            } else {
                this._invocationCallback.onFailure("WebViewBridgeInvocationRunnable:run CallbackStatus.Error", _callbackStatus);
            }
        } else {
            this._invocationCallback.onTimeout();
        }
    }

    public static synchronized void onInvocationComplete(CallbackStatus status) {
        _callbackStatus = status;
        if (_responseTimeout != null) {
            _responseTimeout.open();
        }
    }
}

