/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.finder;

import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.services.ads.gmascar.bridges.AdapterStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializationStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializeListenerBridge;
import com.unity3d.services.ads.gmascar.bridges.MobileAdsBridge;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.Map;

public class GMAInitializer {
    private MobileAdsBridge _mobileAdsBridge;
    private InitializeListenerBridge _initializationListenerBridge;
    private InitializationStatusBridge _initializationStatusBridge;
    private AdapterStatusBridge _adapterStatusBridge;

    public GMAInitializer(MobileAdsBridge mobileAdsBridge, InitializeListenerBridge initializeListenerBridge, InitializationStatusBridge initializationStatusBridge, AdapterStatusBridge adapterStatusBridge) {
        this._mobileAdsBridge = mobileAdsBridge;
        this._initializationListenerBridge = initializeListenerBridge;
        this._initializationStatusBridge = initializationStatusBridge;
        this._adapterStatusBridge = adapterStatusBridge;
    }

    public void initializeGMA() {
        if (this.isInitialized()) {
            return;
        }
        this._mobileAdsBridge.initialize(ClientProperties.getApplicationContext(), this._initializationListenerBridge.createInitializeListenerProxy());
    }

    public boolean initSuccessful(Object initStatus) {
        Map<String, Object> statusMap = this._initializationStatusBridge.getAdapterStatusMap(initStatus);
        Object adapterState = statusMap.get(this._mobileAdsBridge.getClassName());
        if (adapterState != null) {
            if (this._adapterStatusBridge.isGMAInitialized(adapterState)) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.INIT_SUCCESS, new Object[0]);
                return true;
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.INIT_ERROR, new Object[0]);
            return false;
        }
        return false;
    }

    public boolean isInitialized() {
        boolean isInitialized = false;
        try {
            isInitialized = this.initSuccessful(this._mobileAdsBridge.getInitializationStatus());
            return isInitialized;
        }
        catch (Exception e) {
            isInitialized = false;
            DeviceLog.debug("ERROR: Could not get initialization status of GMA SDK - %s", e.getLocalizedMessage());
        }
        finally {
            return isInitialized;
        }
    }

    public InitializeListenerBridge getInitializeListenerBridge() {
        return this._initializationListenerBridge;
    }
}

