/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.v2000.signals;

import android.content.Context;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.unity3d.scar.adapter.common.DispatchGroup;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.scar.adapter.common.signals.ISignalsReader;
import com.unity3d.scar.adapter.v2000.signals.QueryInfoCallback;
import com.unity3d.scar.adapter.v2000.signals.QueryInfoMetadata;
import com.unity3d.scar.adapter.v2000.signals.SignalsStorage;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class SignalsReader
implements ISignalsReader {
    private static Map<String, String> _placementSignalMap;
    private static SignalsStorage _signalsStorage;

    public SignalsReader(SignalsStorage signalsStorage) {
        _signalsStorage = signalsStorage;
    }

    public void getSCARSignals(Context context, String[] interstitialList, String[] rewardedList, ISignalCollectionListener signalCompletionListener) {
        DispatchGroup dispatchGroup = new DispatchGroup();
        for (String interstitialId : interstitialList) {
            dispatchGroup.enter();
            this.getSCARSignal(context, interstitialId, AdFormat.INTERSTITIAL, dispatchGroup);
        }
        for (String rewardedId : rewardedList) {
            dispatchGroup.enter();
            this.getSCARSignal(context, rewardedId, AdFormat.REWARDED, dispatchGroup);
        }
        dispatchGroup.notify((Runnable)new GMAScarDispatchCompleted(signalCompletionListener));
    }

    private void getSCARSignal(Context context, String placementId, AdFormat adType, DispatchGroup dispatchGroup) {
        AdRequest request = new AdRequest.Builder().build();
        QueryInfoMetadata gmaQueryInfoMetadata = new QueryInfoMetadata(placementId);
        QueryInfoCallback gmaQueryInfoCallback = new QueryInfoCallback(gmaQueryInfoMetadata, dispatchGroup);
        _signalsStorage.put(placementId, gmaQueryInfoMetadata);
        QueryInfo.generate((Context)context, (AdFormat)adType, (AdRequest)request, (QueryInfoGenerationCallback)gmaQueryInfoCallback);
    }

    private class GMAScarDispatchCompleted
    implements Runnable {
        private ISignalCollectionListener _signalListener;

        public GMAScarDispatchCompleted(ISignalCollectionListener signalListener) {
            this._signalListener = signalListener;
        }

        @Override
        public void run() {
            _placementSignalMap = new HashMap();
            String errorMessage = null;
            for (Map.Entry<String, QueryInfoMetadata> queryInfoMetadata : _signalsStorage.getPlacementQueryInfoMap().entrySet()) {
                QueryInfoMetadata currentQueryMetadata = queryInfoMetadata.getValue();
                _placementSignalMap.put(currentQueryMetadata.getPlacementId(), currentQueryMetadata.getQueryStr());
                if (currentQueryMetadata.getError() == null) continue;
                errorMessage = currentQueryMetadata.getError();
            }
            if (_placementSignalMap.size() > 0) {
                JSONObject placementJSON = new JSONObject(_placementSignalMap);
                this._signalListener.onSignalsCollected(placementJSON.toString());
            } else if (errorMessage == null) {
                this._signalListener.onSignalsCollected("");
            } else {
                this._signalListener.onSignalsCollectionFailed(errorMessage);
            }
        }
    }
}

