/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PageRequest {
    private static final Logger log = LoggerFactory.getLogger(PageRequest.class);
    private Integer limit;
    private String order;
    private String before;
    private String after;

    public static PageRequestBuilder builder() {
        return new PageRequestBuilder();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOrder() {
        return this.order;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public PageRequest() {
    }

    public PageRequest(Integer limit, String order, String before, String after) {
        this.limit = limit;
        this.order = order;
        this.before = before;
        this.after = after;
    }

    public static class PageRequestBuilder {
        private Integer limit;
        private String order;
        private String before;
        private String after;

        PageRequestBuilder() {
        }

        public PageRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PageRequestBuilder order(String order) {
            this.order = order;
            return this;
        }

        public PageRequestBuilder before(String before) {
            this.before = before;
            return this;
        }

        public PageRequestBuilder after(String after) {
            this.after = after;
            return this;
        }

        public PageRequest build() {
            return new PageRequest(this.limit, this.order, this.before, this.after);
        }

        public String toString() {
            return "PageRequest.PageRequestBuilder(limit=" + this.limit + ", order=" + this.order + ", before=" + this.before + ", after=" + this.after + ")";
        }
    }

    public static enum Order {
        DESC("desc"),
        ASC("asc");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Order(String name) {
            this.name = name;
        }
    }
}

