/*
 * Decompiled with CFR 0.152.
 */
package com.uc.crashsdk.export;

public class LogType {
    public static final int NATIVE = 1;
    public static final int JAVA = 16;
    public static final int UNEXP = 256;
    public static final int ANR = 0x100000;
    public static final int UNEXP_OTHER = 768;
    public static final int UNEXP_ANR = 1280;
    public static final int UNEXP_LOW_MEMORY = 2304;
    public static final int UNEXP_KILL_PROCESS = 4352;
    public static final int UNEXP_EXIT = 8448;
    public static final int UNEXP_RESTART = 16640;
    public static final int UNEXP_KNOWN_REASON = 32000;
    public static final int UNEXP_ALL = 32512;
    public static final String NATIVE_TYPE = "jni";
    public static final String JAVA_TYPE = "java";
    public static final String ANR_TYPE = "anr";
    public static final String UNEXP_TYPE = "unexp";

    public static boolean isForJava(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isForNative(int n) {
        return (n & 1) != 0;
    }

    public static boolean isForANR(int n) {
        return (n & 0x100000) != 0;
    }

    public static boolean isForUnexp(int n) {
        return (n & 0x100) != 0;
    }

    public static int addType(int n, int n2) {
        return (n | n2) & 0x100111;
    }

    public static int removeType(int n, int n2) {
        return n & ~(n2 & 0x100111);
    }
}

