/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.memleaksdk.monitor;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Pair;
import com.efs.sdk.memleaksdk.monitor.UMonitorHeapResult;
import com.efs.sdk.memleaksdk.monitor.internal.aa;
import com.efs.sdk.memleaksdk.monitor.internal.ah;
import com.efs.sdk.memleaksdk.monitor.internal.ak;
import com.efs.sdk.memleaksdk.monitor.internal.al;
import com.efs.sdk.memleaksdk.monitor.internal.ar;
import com.efs.sdk.memleaksdk.monitor.internal.at;
import com.efs.sdk.memleaksdk.monitor.internal.au;
import com.efs.sdk.memleaksdk.monitor.internal.av;
import com.efs.sdk.memleaksdk.monitor.internal.ay;
import com.efs.sdk.memleaksdk.monitor.internal.bc;
import com.efs.sdk.memleaksdk.monitor.internal.bg;
import com.efs.sdk.memleaksdk.monitor.internal.bi;
import com.efs.sdk.memleaksdk.monitor.internal.bk;
import com.efs.sdk.memleaksdk.monitor.internal.bp;
import com.efs.sdk.memleaksdk.monitor.internal.cm;
import com.efs.sdk.memleaksdk.monitor.internal.e;
import com.efs.sdk.memleaksdk.monitor.internal.g;
import com.efs.sdk.memleaksdk.monitor.internal.z;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class UMonitorService
extends IntentService {
    private au mHeapGraph;
    private final aa mLeakModel = new aa();
    private final Set<Long> mLeakingObjectIds = new HashSet<Long>();
    private final Map<Long, String> mLeakReasonTable = new HashMap<Long, String>();
    private static final String TAG = "UMonitor.Service";
    private static final String ACTIVITY_CLASS_NAME = "android.app.Activity";
    private static final String NATIVE_FRAGMENT_CLASS_NAME = "android.app.Fragment";
    private static final String SUPPORT_FRAGMENT_CLASS_NAME = "android.support.v4.app.Fragment";
    private static final String ANDROIDX_FRAGMENT_CLASS_NAME = "androidx.fragment.app.Fragment";
    private static final String FINISHED_FIELD_NAME = "mFinished";
    private static final String DESTROYED_FIELD_NAME = "mDestroyed";
    private static final String FRAGMENT_MANAGER_FIELD_NAME = "mFragmentManager";
    private static final String FRAGMENT_MCALLED_FIELD_NAME = "mCalled";
    public static final String HPROF_FILE = "HPROF_FILE";
    public static final String JSON_FILE = "JSON_FILE";
    public static final String ROOT_PATH = "ROOT_PATH";
    public static final String RESULT_RECEIVER = "RESULT_RECEIVER";
    private static final String FD = "FD";
    private static final String THREAD = "THREAD";
    private static final String SDK = "SDK";
    private static final String MANUFACTURE = "MANUFACTURE";
    private static final String MODEL = "MODEL";
    private static final String TIME = "TIME";
    private static final String REASON = "REASON";
    private static final String USAGE_TIME = "USAGE_TIME";
    private static final String CURRENT_PAGE = "CURRENT_PAGE";

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        ResultReceiver resultReceiver = (ResultReceiver)intent.getParcelableExtra(RESULT_RECEIVER);
        try {
            String string = intent.getStringExtra(HPROF_FILE);
            String string2 = intent.getStringExtra(JSON_FILE);
            String string3 = intent.getStringExtra(ROOT_PATH);
            e.a(string3);
            this.buildIndex(string);
            this.buildJson(intent);
            this.filterLeakingObjects();
            this.findPathsToGcRoot();
            if (this.mLeakModel.a()) {
                this.fillJsonFile(string2);
                if (resultReceiver != null) {
                    resultReceiver.send(1001, null);
                }
            } else {
                g.b(TAG, "not found leak");
                if (resultReceiver != null) {
                    resultReceiver.send(1003, null);
                }
            }
        }
        catch (Throwable throwable) {
            g.b(TAG, "onHandleIntent", throwable);
            try {
                if (resultReceiver != null) {
                    resultReceiver.send(1002, null);
                }
            }
            catch (Throwable throwable2) {
                g.b(TAG, "send result failed", throwable2);
            }
        }
        System.exit(0);
    }

    private void buildIndex(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        g.b(TAG, "start analyze");
        HashSet<bc> hashSet = new HashSet<bc>();
        hashSet.add(bc.p);
        hashSet.add(bc.q);
        hashSet.add(bc.s);
        hashSet.add(bc.t);
        hashSet.add(bc.u);
        hashSet.add(bc.w);
        this.mHeapGraph = ay.a.a(new File(string), null, hashSet);
    }

    private void buildJson(Intent intent) {
        aa.c c2;
        if (intent == null) {
            return;
        }
        this.mLeakModel.a = c2 = new aa.c();
        c2.a = intent.getStringExtra(THREAD);
        c2.b = intent.getStringExtra(FD);
        c2.e = intent.getStringExtra(SDK);
        c2.f = intent.getStringExtra(MANUFACTURE);
        c2.g = intent.getStringExtra(MODEL);
        c2.j = intent.getStringExtra(USAGE_TIME);
        c2.i = intent.getStringExtra(CURRENT_PAGE);
        c2.k = intent.getStringExtra(TIME);
        c2.l = intent.getStringExtra(REASON);
        File file = e.a(e.e());
        e.a(file, new e.a(){

            @Override
            public boolean a(String string) {
                c2.d.add(string);
                return true;
            }
        });
        file.delete();
        file = e.a(e.d());
        e.a(file, new e.a(){

            @Override
            public boolean a(String string) {
                c2.c.add(string);
                return true;
            }
        });
        file.delete();
    }

    private void filterLeakingObjects() {
        Object object;
        Object object2;
        long l2 = System.currentTimeMillis();
        g.b(TAG, "filterLeakingObjects " + Thread.currentThread());
        if (this.mHeapGraph == null) {
            return;
        }
        av.b b2 = this.mHeapGraph.a(ACTIVITY_CLASS_NAME);
        av.b b3 = this.mHeapGraph.a(ANDROIDX_FRAGMENT_CLASS_NAME);
        if (b3 == null && (b3 = this.mHeapGraph.a(NATIVE_FRAGMENT_CLASS_NAME)) == null) {
            b3 = this.mHeapGraph.a(SUPPORT_FRAGMENT_CLASS_NAME);
        }
        LinkedHashMap<Long, Object> linkedHashMap = new LinkedHashMap<Long, Object>();
        LinkedHashMap<Long, a> linkedHashMap2 = new LinkedHashMap<Long, a>();
        for (Object object3 : this.mHeapGraph.e()) {
            Object object4;
            if (((av.c)object3).f()) continue;
            Object object5 = object3;
            cm.b b4 = ((av.c)object5).c;
            long l3 = b4.a;
            object2 = (Pair)linkedHashMap.get(l3);
            if (object2 == null) {
                object = new ArrayList();
                object4 = ((av.c)object3).i().k().iterator();
                while (object4.hasNext()) {
                    ((ArrayList)object).add(object4.next());
                }
                long l4 = 0L;
                long l5 = 0L;
                if (((ArrayList)object).size() >= 2) {
                    l4 = ((av.b)((ArrayList)object).get(((ArrayList)object).size() - 2)).a();
                }
                if (((ArrayList)object).size() >= 5) {
                    l5 = ((av.b)((ArrayList)object).get(((ArrayList)object).size() - 5)).a();
                }
                object2 = Pair.create((Object)l4, (Object)l5);
                linkedHashMap.put(l3, object2);
            }
            if (b2 != null && b2.a() == ((Long)((Pair)object2).second).longValue()) {
                object = ((av.c)object3).b(ACTIVITY_CLASS_NAME, DESTROYED_FIELD_NAME);
                if (object == null || (object4 = ((av.c)object3).b(ACTIVITY_CLASS_NAME, FINISHED_FIELD_NAME)) == null) continue;
                object5 = object;
                Boolean bl2 = ((at)object5).c.a();
                object5 = object4;
                Boolean bl3 = ((at)object5).c.a();
                if (bl2 != Boolean.TRUE && bl3 != Boolean.TRUE) continue;
                this.updateClassObjectCounterMap(linkedHashMap2, l3, true);
                g.b(TAG, "activity name : " + ((av.c)object3).h() + " mDestroyed:" + bl2 + " mFinished:" + bl3 + " objectId:" + (((av.c)object3).a() & 0xFFFFFFFFL));
                this.mLeakingObjectIds.add(((av.c)object3).a());
                this.mLeakReasonTable.put(((av.c)object3).a(), "Activity Leak");
                g.b(TAG, ((av.c)object3).h() + " objectId:" + ((av.c)object3).a());
                continue;
            }
            if (b3 == null || b3.a() != ((Long)((Pair)object2).first).longValue() || (object = ((av.c)object3).b(b3.f(), FRAGMENT_MANAGER_FIELD_NAME)) == null) continue;
            object5 = object;
            if (((at)object5).c.f() == null || (object4 = ((av.c)object3).b(b3.f(), FRAGMENT_MCALLED_FIELD_NAME)) == null) continue;
            object5 = object4;
            Boolean bl4 = ((at)object5).c.a();
            if (bl4 == null) continue;
            this.updateClassObjectCounterMap(linkedHashMap2, l3, bl4);
            g.b(TAG, "fragment name:" + ((av.c)object3).h() + " isLeak:" + bl4);
            if (!bl4.booleanValue()) continue;
            this.mLeakingObjectIds.add(((av.c)object3).a());
            this.mLeakReasonTable.put(((av.c)object3).a(), "Fragment Leak");
            g.b(TAG, ((av.c)object3).h() + " objectId:" + ((av.c)object3).a());
        }
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            aa.a a2 = new aa.a();
            object2 = this.mHeapGraph.a((Long)entry.getKey()).d();
            if (object2 != null) {
                a2.a = ((av.b)object2).f();
            }
            a2.b = ((a)entry.getValue()).a + "";
            this.mLeakModel.c.add(a2);
            object = String.format(Locale.US, "class: %s, leak count:%s", a2.a, a2.b);
            g.b(TAG, (String)object);
        }
        long l6 = System.currentTimeMillis();
        if (this.mLeakModel.a != null) {
            this.mLeakModel.a.o = (float)(l6 - l2) / 1000.0f + "";
        }
        g.b(TAG, "filter leaking objects cost: " + (float)(l6 - l2) / 1000.0f + "s");
    }

    private void findPathsToGcRoot() {
        long l2 = System.currentTimeMillis();
        ar ar2 = new ar(new bp(){

            @Override
            public void a(bp.b b2) {
                g.b(UMonitorService.TAG, "heap analysis start: " + b2.name());
            }
        });
        ar.a a2 = new ar.a(this.mHeapGraph, ak.b(), true, new ArrayList());
        ar.c c2 = ar2.a(a2, this.mLeakingObjectIds);
        Object object = c2;
        g.b(TAG, "size: " + ((ar.c)object).a.size());
        object = c2;
        for (al al2 : ((ar.c)object).a) {
            g.b(TAG, al2.b() + ", signature:" + al2.a() + ", trace size:" + al2.c().size());
            List<bg> list = al2.c();
            if (list.isEmpty()) continue;
            bg bg2 = list.get(0);
            object = bg2;
            object = ((bg)object).a;
            String string = ((bg.b)((Object)object)).j;
            object = bg2;
            object = ((bg)object).c;
            Set<String> set = ((bi)object).c;
            object = bg2;
            object = ((bg)object).c;
            Long l3 = ((bi)object).a;
            object = bg2;
            ((bg)object).c.a(String.valueOf(this.mLeakReasonTable.get(l3)));
            object = bg2;
            object = ((bg)object).c;
            object = bg2;
            object = bg2;
            object = ((bg)object).c;
            object = bg2;
            object = ((bg)object).c;
            g.b(TAG, string + ", class:" + ((bi)object).b + ", type:" + ((bg)object).c.b() + ", labels:" + set + ", reason:" + ((bi)object).e + ", objId:" + (((bi)object).a & 0xFFFFFFFFL));
            aa.b b2 = new aa.b();
            b2.c = string;
            object = bg2;
            object = ((bg)object).c;
            b2.d = ((bi)object).b;
            object = bg2;
            object = ((bg)object).c;
            b2.b = ((bi)object).e;
            b2.e = al2.a();
            g.b(TAG, "signature origin: \n" + al2.c().get(0).toString());
            b2.a = al2.c().size();
            this.mLeakModel.b.add(b2);
            object = bg2;
            for (bk bk2 : ((bg)object).b) {
                object = bk2;
                object = ((bk)object).a;
                String string2 = ((bi)object).b;
                String string3 = bk2.b();
                aa.b.a a3 = new aa.b.a();
                if (string3.startsWith("[")) {
                    object = bk2;
                    object = ((bk)object).a;
                    a3.a = "array " + string2 + ".[" + ((bi)object).g + "]";
                } else {
                    a3.a = string2 + "." + string3;
                }
                g.a(TAG, "\t" + a3.a);
                b2.g.add(a3);
            }
            aa.b.a a4 = new aa.b.a();
            object = bg2;
            object = ((bg)object).c;
            a4.a = ((bi)object).b;
            object = bg2;
            object = ((bg)object).c;
            b2.f = ((bi)object).f + "";
            b2.g.add(a4);
        }
        long l4 = System.currentTimeMillis();
        if (this.mLeakModel.a != null) {
            this.mLeakModel.a.p = (float)(l4 - l2) / 1000.0f + "";
        }
        g.b(TAG, "find paths to GcRoot cost: " + (float)(l4 - l2) / 1000.0f + "s");
    }

    private void fillJsonFile(String string) {
        try {
            JSONObject jSONObject = this.mLeakModel.b();
            e.a(new File(string), jSONObject.toString());
        }
        catch (Exception exception) {
            g.b(TAG, "json write failed", exception);
        }
    }

    private a updateClassObjectCounterMap(Map<Long, a> map, long l2, boolean bl2) {
        a a2 = map.get(l2);
        if (a2 == null) {
            a2 = new a(0);
            map.put(l2, a2);
        }
        ++a2.a;
        if (bl2) {
            ++a2.b;
        }
        return a2;
    }

    public UMonitorService() {
        super("UMonitorService");
    }

    public static void startAnalysisService(Context context, String string, String string2, z z2, UMonitorHeapResult.a a2) {
        try {
            g.b(TAG, "startService");
            UMonitorHeapResult uMonitorHeapResult = new UMonitorHeapResult();
            uMonitorHeapResult.a(a2);
            Intent intent = new Intent(context, UMonitorService.class);
            intent.putExtra(HPROF_FILE, string);
            intent.putExtra(JSON_FILE, string2);
            File file = e.a();
            intent.putExtra(ROOT_PATH, file.getPath());
            intent.putExtra(RESULT_RECEIVER, (Parcelable)uMonitorHeapResult);
            File[] fileArray = new File("/proc/self/fd").listFiles();
            intent.putExtra(FD, String.valueOf(fileArray != null ? fileArray.length : 0));
            intent.putExtra(THREAD, String.valueOf(ah.e.a));
            intent.putExtra(MANUFACTURE, Build.MANUFACTURER);
            intent.putExtra(SDK, String.valueOf(Build.VERSION.SDK_INT));
            intent.putExtra(MODEL, Build.MODEL);
            intent.putExtra(TIME, new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS", Locale.CHINESE).format(new Date()));
            if (z2.a != null) {
                intent.putExtra(REASON, z2.a);
            }
            if (z2.c != null) {
                intent.putExtra(CURRENT_PAGE, z2.c);
            }
            if (z2.b != null) {
                intent.putExtra(USAGE_TIME, z2.b);
            }
            context.startService(intent);
        }
        catch (Throwable throwable) {
            g.b(TAG, "startAnalysisService", throwable);
        }
    }

    static final class a {
        int a;
        int b;

        private a() {
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }
}

