/*
 * Decompiled with CFR 0.152.
 */
package com.uber.simplestore.proto.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.uber.simplestore.NamespaceConfig;
import com.uber.simplestore.SimpleStore;
import com.uber.simplestore.SimpleStoreConfig;
import com.uber.simplestore.proto.SimpleProtoStore;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public final class SimpleProtoStoreImpl
implements SimpleProtoStore {
    private final SimpleStore simpleStore;
    private final NamespaceConfig config;

    SimpleProtoStoreImpl(SimpleStore simpleStore, NamespaceConfig config) {
        this.simpleStore = simpleStore;
        this.config = config;
    }

    @Override
    public <T extends MessageLite> ListenableFuture<T> get(String key, Parser<T> parser) {
        return Futures.transformAsync((ListenableFuture)this.simpleStore.get(key), bytes -> {
            MessageLite parsed;
            if (bytes == null || ((byte[])bytes).length == 0) {
                try {
                    parsed = (MessageLite)parser.parseFrom(ByteString.EMPTY);
                }
                catch (InvalidProtocolBufferException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }
            try {
                parsed = (MessageLite)parser.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException e) {
                if (this.config.equals(NamespaceConfig.CACHE)) {
                    return Futures.immediateFuture((Object)((MessageLite)parser.parseFrom(ByteString.EMPTY)));
                }
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateFuture((Object)parsed);
        }, (Executor)SimpleStoreConfig.getComputationExecutor());
    }

    @Override
    public <T extends MessageLite> ListenableFuture<T> put(String key, @Nullable T value) {
        ListenableFuture proto = Futures.submitAsync(() -> {
            byte[] bytes = null;
            if (value != null && !value.equals(value.getDefaultInstanceForType())) {
                bytes = value.toByteArray();
            }
            return Futures.immediateFuture(bytes);
        }, (Executor)SimpleStoreConfig.getComputationExecutor());
        return Futures.transformAsync((ListenableFuture)proto, p -> Futures.transform((ListenableFuture)this.simpleStore.put(key, p), o -> value, (Executor)SimpleStoreConfig.getComputationExecutor()), (Executor)SimpleStoreConfig.getComputationExecutor());
    }

    public ListenableFuture<Boolean> contains(String key) {
        return Futures.transform(this.get(key), value -> value != null && ((byte[])value).length > 0, (Executor)SimpleStoreConfig.getComputationExecutor());
    }

    public ListenableFuture<String> getString(String key) {
        return this.simpleStore.getString(key);
    }

    public ListenableFuture<String> putString(String key, @Nullable String value) {
        return this.simpleStore.putString(key, value);
    }

    public ListenableFuture<byte[]> get(String key) {
        return this.simpleStore.get(key);
    }

    public ListenableFuture<byte[]> put(String key, @Nullable byte[] value) {
        return this.simpleStore.put(key, value);
    }

    public ListenableFuture<Void> remove(String key) {
        return this.simpleStore.remove(key);
    }

    public ListenableFuture<Void> clear() {
        return this.simpleStore.clear();
    }

    public ListenableFuture<Void> deleteAllNow() {
        return this.simpleStore.deleteAllNow();
    }

    public void close() {
        this.simpleStore.close();
    }
}

