/*
 * Decompiled with CFR 0.152.
 */
package com.uber.m3.tally;

import com.uber.m3.tally.Counter;
import com.uber.m3.tally.MetricBase;
import com.uber.m3.tally.Reportable;
import com.uber.m3.tally.ScopeImpl;
import com.uber.m3.tally.StatsReporter;
import com.uber.m3.util.ImmutableMap;
import java.util.concurrent.atomic.AtomicLong;

class CounterImpl
extends MetricBase
implements Counter,
Reportable {
    private final AtomicLong prev = new AtomicLong(0L);
    private final AtomicLong curr = new AtomicLong(0L);

    protected CounterImpl(ScopeImpl scope, String fqn) {
        super(fqn);
        scope.addToReportingQueue(this);
    }

    @Override
    public void inc(long delta) {
        this.curr.getAndAdd(delta);
    }

    long value() {
        long previous;
        long current = this.curr.get();
        if (current == (previous = this.prev.get())) {
            return 0L;
        }
        this.prev.set(current);
        return current - previous;
    }

    @Override
    public void report(ImmutableMap<String, String> tags, StatsReporter reporter) {
        long delta = this.value();
        if (delta == 0L) {
            return;
        }
        reporter.reportCounter(this.getQualifiedName(), tags, delta);
    }

    long snapshot() {
        return this.curr.get() - this.prev.get();
    }
}

