/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.StatsReceiverProxy;
import com.twitter.finagle.stats.TranslatingStatsReceiver$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public abstract class TranslatingStatsReceiver
implements StatsReceiver,
StatsReceiverProxy {
    private final StatsReceiver self;

    public static StatsReceiver translateIdentity(StatsReceiver statsReceiver, Function1<MetricBuilder.Identity, MetricBuilder.Identity> function1) {
        return TranslatingStatsReceiver$.MODULE$.translateIdentity(statsReceiver, function1);
    }

    public TranslatingStatsReceiver(StatsReceiver self) {
        this.self = self;
    }

    @Override
    public StatsReceiver self() {
        return this.self;
    }

    public abstract MetricBuilder translate(MetricBuilder var1);

    @Override
    public Counter counter(MetricBuilder metricBuilder) {
        return this.self().counter(this.translate(metricBuilder));
    }

    @Override
    public Stat stat(MetricBuilder metricBuilder) {
        return this.self().stat(this.translate(metricBuilder));
    }

    @Override
    public Gauge addGauge(MetricBuilder metricBuilder, Function0 f) {
        return this.self().addGauge(this.translate(metricBuilder), f);
    }

    private static final class IdentityTranslatingStatsReceiver
    extends TranslatingStatsReceiver {
        private final Function1<MetricBuilder.Identity, MetricBuilder.Identity> f;

        public IdentityTranslatingStatsReceiver(StatsReceiver sr, Function1<MetricBuilder.Identity, MetricBuilder.Identity> f) {
            this.f = f;
            super(sr);
        }

        @Override
        public MetricBuilder translate(MetricBuilder builder) {
            return builder.withIdentity((MetricBuilder.Identity)this.f.apply((Object)builder.identity()));
        }
    }

    public static final class LabelTranslatingStatsReceiver
    extends TranslatingStatsReceiver {
        private final Tuple2<String, String> labelPair;

        public LabelTranslatingStatsReceiver(StatsReceiver sr, String labelName, String labelValue) {
            super(sr);
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(labelName)));
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(labelValue)));
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)labelName);
            this.labelPair = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)labelValue);
        }

        @Override
        public MetricBuilder translate(MetricBuilder builder) {
            return builder.withIdentity(this.newIdentity(builder.identity()));
        }

        private MetricBuilder.Identity newIdentity(MetricBuilder.Identity identity) {
            Map map = (Map)identity.labels().$plus(this.labelPair);
            Seq<String> seq = identity.copy$default$1();
            Seq<String> seq2 = identity.copy$default$2();
            MetricBuilder.IdentityType identityType = identity.copy$default$4();
            return identity.copy(seq, seq2, (Map<String, String>)map, identityType);
        }
    }
}

