/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public class CachedRegex
implements Function1<Map<String, Number>, Map<String, Number>> {
    private final Regex regex;
    private final ConcurrentHashMap regexMatchCache;
    private final Function1<String, Object> filterFn;

    public CachedRegex(Regex regex) {
        this.regex = regex;
        this.regexMatchCache = new ConcurrentHashMap();
        this.filterFn = (Function1 & Serializable)key -> {
            boolean bl;
            Boolean cached = this.regexMatchCache().get(key);
            if (cached != null) {
                bl = BoxesRunTime.unboxToBoolean((Object)cached);
            } else {
                boolean result = regex.pattern().matcher((CharSequence)key).matches();
                this.regexMatchCache().put((String)key, Predef$.MODULE$.boolean2Boolean(result));
                bl = result;
            }
            boolean matched = bl;
            return !matched;
        };
    }

    public ConcurrentHashMap<String, Boolean> regexMatchCache() {
        return this.regexMatchCache;
    }

    public Map<String, Number> apply(Map<String, Number> samples) {
        this.regexMatchCache().forEachKey(Long.MAX_VALUE, new Consumer<String>(samples, this){
            private final Map samples$1;
            private final CachedRegex $outer;
            {
                this.samples$1 = samples$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void accept(String key) {
                if (!this.samples$1.contains((Object)key)) {
                    this.$outer.regexMatchCache().remove(key);
                }
            }
        });
        return samples.view().filterKeys(this.filterFn).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

