/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.finagle.stats.BucketAndCount;
import com.twitter.finagle.stats.BucketAndCount$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.HistogramDetail;
import com.twitter.finagle.stats.InMemoryStatsReceiver$;
import com.twitter.finagle.stats.Metadata;
import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.MetricBuilder$CounterType$;
import com.twitter.finagle.stats.MetricBuilder$GaugeType$;
import com.twitter.finagle.stats.MetricBuilder$HistogramType$;
import com.twitter.finagle.stats.ReadableCounter;
import com.twitter.finagle.stats.ReadableStat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.Verbosity;
import com.twitter.finagle.stats.WithHistogramDetails;
import com.twitter.finagle.stats.exp.ExpressionSchema;
import com.twitter.finagle.stats.exp.ExpressionSchema$ExpressionCollisionException$;
import com.twitter.finagle.stats.exp.ExpressionSchemaKey;
import com.twitter.util.Throw$;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.SortedMap;
import scala.collection.SortedMap$;
import scala.collection.SortedMapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public class InMemoryStatsReceiver
implements StatsReceiver,
WithHistogramDetails {
    private final scala.collection.mutable.Map verbosity = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final scala.collection.mutable.Map counters = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final scala.collection.mutable.Map stats = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final scala.collection.mutable.Map gauges = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final scala.collection.mutable.Map schemas = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final scala.collection.mutable.Map expressions = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();

    public static int MaxStatsValues() {
        return InMemoryStatsReceiver$.MODULE$.MaxStatsValues();
    }

    public static String OmittedValuesStr() {
        return InMemoryStatsReceiver$.MODULE$.OmittedValuesStr();
    }

    public static <K, V> RichMap<K, V> RichMap(scala.collection.mutable.Map<K, V> map) {
        return InMemoryStatsReceiver$.MODULE$.RichMap(map);
    }

    public static String statValuesToStr(Seq<Object> seq) {
        return InMemoryStatsReceiver$.MODULE$.statValuesToStr(seq);
    }

    @Override
    public InMemoryStatsReceiver repr() {
        return this;
    }

    public scala.collection.mutable.Map<Seq<String>, Verbosity> verbosity() {
        return this.verbosity;
    }

    public scala.collection.mutable.Map<Seq<String>, Object> counters() {
        return this.counters;
    }

    public scala.collection.mutable.Map<Seq<String>, Seq<Object>> stats() {
        return this.stats;
    }

    public scala.collection.mutable.Map<Seq<String>, Function0<Object>> gauges() {
        return this.gauges;
    }

    public scala.collection.mutable.Map<Seq<String>, MetricBuilder> schemas() {
        return this.schemas;
    }

    public scala.collection.mutable.Map<ExpressionSchemaKey, ExpressionSchema> expressions() {
        return this.expressions;
    }

    @Override
    public ReadableCounter counter(Seq<String> name) {
        return this.counter(this.metricBuilder(MetricBuilder$CounterType$.MODULE$).withName(name));
    }

    @Override
    public ReadableCounter counter(String ... name) {
        return this.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])name));
    }

    @Override
    public ReadableCounter counter(MetricBuilder metricBuilder) {
        this.validateMetricType(metricBuilder, MetricBuilder$CounterType$.MODULE$);
        return new Counter(metricBuilder, this){
            private final MetricBuilder metricBuilder$1;
            private final InMemoryStatsReceiver $outer;
            {
                this.metricBuilder$1 = metricBuilder$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc(metricBuilder$1.name());
                $outer.verbosity().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)metricBuilder$1.verbosity()));
                scala.collection.mutable.Map<Seq<String>, Object> map = $outer.counters();
                synchronized (map) {
                    BoxedUnit boxedUnit;
                    if (!$outer.counters().contains(metricBuilder$1.name())) {
                        $outer.counters().update(metricBuilder$1.name(), (Object)BoxesRunTime.boxToLong((long)0L));
                        $outer.schemas().update(metricBuilder$1.name(), (Object)metricBuilder$1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void incr(long delta) {
                scala.collection.mutable.Map<Seq<String>, Object> map = this.$outer.counters();
                synchronized (map) {
                    long oldValue = this.apply();
                    this.$outer.counters().update(this.metricBuilder$1.name(), (Object)BoxesRunTime.boxToLong((long)(oldValue + delta)));
                }
            }

            public long apply() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.counters().getOrElse(this.metricBuilder$1.name(), InMemoryStatsReceiver::com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$1$$_$apply$$anonfun$1));
            }

            public Metadata metadata() {
                return this.metricBuilder$1;
            }

            public String toString() {
                return "Counter(" + this.metricBuilder$1.name().mkString("/") + "=" + this.apply() + ")";
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$1$$_$apply$$anonfun$1()}, serializedLambda);
            }
        };
    }

    @Override
    public ReadableStat stat(Seq<String> name) {
        return this.stat(this.metricBuilder(MetricBuilder$HistogramType$.MODULE$).withName(name));
    }

    @Override
    public ReadableStat stat(String ... name) {
        return this.stat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])name));
    }

    @Override
    public ReadableStat stat(MetricBuilder metricBuilder) {
        this.validateMetricType(metricBuilder, MetricBuilder$HistogramType$.MODULE$);
        return new ReadableStat(metricBuilder, this){
            private final MetricBuilder metricBuilder$1;
            private final InMemoryStatsReceiver $outer;
            {
                this.metricBuilder$1 = metricBuilder$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc(metricBuilder$3.name());
                $outer.verbosity().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)metricBuilder$3.verbosity()));
                scala.collection.mutable.Map<Seq<String>, Seq<Object>> map = $outer.stats();
                synchronized (map) {
                    BoxedUnit boxedUnit;
                    if (!$outer.stats().contains(metricBuilder$3.name())) {
                        $outer.stats().update(metricBuilder$3.name(), (Object)package$.MODULE$.Nil());
                        $outer.schemas().update(metricBuilder$3.name(), (Object)metricBuilder$3);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void add(float value) {
                scala.collection.mutable.Map<Seq<String>, Seq<Object>> map = this.$outer.stats();
                synchronized (map) {
                    Seq oldValue = this.apply();
                    this.$outer.stats().update(this.metricBuilder$1.name(), oldValue.$colon$plus((Object)BoxesRunTime.boxToFloat((float)value)));
                }
            }

            public Seq apply() {
                return (Seq)this.$outer.stats().getOrElse(this.metricBuilder$1.name(), InMemoryStatsReceiver::com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$2$$_$apply$$anonfun$2);
            }

            public Metadata metadata() {
                return this.metricBuilder$1;
            }

            public String toString() {
                Seq vals = this.apply();
                return "Stat(" + this.metricBuilder$1.name().mkString("/") + "=" + InMemoryStatsReceiver$.MODULE$.statValuesToStr((Seq<Object>)vals) + ")";
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$2$$_$apply$$anonfun$2()}, serializedLambda);
            }
        };
    }

    @Override
    public Gauge addGauge(MetricBuilder metricBuilder, Function0 f) {
        this.validateMetricType(metricBuilder, MetricBuilder$GaugeType$.MODULE$);
        return new Gauge(metricBuilder, f, this){
            private final MetricBuilder metricBuilder$1;
            private final InMemoryStatsReceiver $outer;
            {
                this.metricBuilder$1 = metricBuilder$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc(metricBuilder$5.name());
                $outer.gauges().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, () -> InMemoryStatsReceiver.com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$3$$_$$lessinit$greater$$anonfun$1(f$1)));
                Seq seq2 = (Seq)Predef$.MODULE$.ArrowAssoc(metricBuilder$5.name());
                $outer.schemas().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq2, (Object)metricBuilder$5));
                Seq seq3 = (Seq)Predef$.MODULE$.ArrowAssoc(metricBuilder$5.name());
                $outer.verbosity().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq3, (Object)metricBuilder$5.verbosity()));
            }

            public void remove() {
                this.$outer.gauges().$minus$eq(this.metricBuilder$1.name());
                this.$outer.schemas().$minus$eq(this.metricBuilder$1.name());
            }

            public Metadata metadata() {
                return this.metricBuilder$1;
            }

            public String toString() {
                float f;
                Option option = this.$outer.gauges().get(this.metricBuilder$1.name());
                if (option instanceof Some) {
                    Function0 fn = (Function0)((Some)option).value();
                    f = fn.apply$mcF$sp();
                } else if (None$.MODULE$.equals(option)) {
                    f = -0.0f;
                } else {
                    throw new MatchError((Object)option);
                }
                float current = f;
                return "Gauge(" + this.metricBuilder$1.name().mkString("/") + "=" + current + ")";
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$3$$_$$lessinit$greater$$anonfun$1(scala.Function0 )}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "InMemoryStatsReceiver";
    }

    public void print(PrintStream p) {
        this.print(p, false);
    }

    public void print(PrintStream p, boolean includeHeaders) {
        SortedMap sortedCounters = InMemoryStatsReceiver$.MODULE$.RichMap(InMemoryStatsReceiver$.MODULE$.RichMap(this.counters()).mapKeys((Function1 & Serializable)_$1 -> _$1.mkString("/"))).toSortedMap(Ordering.String$.MODULE$);
        SortedMap sortedGauges = InMemoryStatsReceiver$.MODULE$.RichMap(InMemoryStatsReceiver$.MODULE$.RichMap(this.gauges()).mapKeys((Function1 & Serializable)_$2 -> _$2.mkString("/"))).toSortedMap(Ordering.String$.MODULE$);
        SortedMap sortedStats = InMemoryStatsReceiver$.MODULE$.RichMap(InMemoryStatsReceiver$.MODULE$.RichMap(this.stats()).mapKeys((Function1 & Serializable)_$3 -> _$3.mkString("/"))).toSortedMap(Ordering.String$.MODULE$);
        if (includeHeaders && sortedCounters.nonEmpty()) {
            p.println("Counters:");
            p.println("---------");
        }
        sortedCounters.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
            p.println(StringOps$.MODULE$.format$extension("%s %d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, BoxesRunTime.boxToLong((long)v)})));
        });
        if (includeHeaders && sortedGauges.nonEmpty()) {
            p.println("\nGauges:");
            p.println("-------");
        }
        sortedGauges.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Function0 g = (Function0)tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Function0 g = (Function0)tuple2._2();
            p.println(StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%s %f"), Locale.US, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, BoxesRunTime.boxToFloat((float)g.apply$mcF$sp())})));
        });
        if (includeHeaders && sortedStats.nonEmpty()) {
            p.println("\nStats:");
            p.println("------");
        }
        sortedStats.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Seq s = (Seq)tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Seq s = (Seq)tuple2._2();
            return s.nonEmpty();
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Seq s = (Seq)tuple2._2();
            p.println(StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%s %f %s"), Locale.US, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)s.sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)s.size())), InMemoryStatsReceiver$.MODULE$.statValuesToStr((Seq<Object>)s)})));
        });
    }

    public void printSchemas(PrintStream p) {
        SortedMap sortedSchemas = InMemoryStatsReceiver$.MODULE$.RichMap(InMemoryStatsReceiver$.MODULE$.RichMap(this.schemas()).mapKeys((Function1 & Serializable)_$4 -> _$4.mkString("/"))).toSortedMap(Ordering.String$.MODULE$);
        sortedSchemas.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                MetricBuilder schema = (MetricBuilder)tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            MetricBuilder schema = (MetricBuilder)tuple2._2();
            p.println("" + k + " " + schema);
        });
    }

    public void clear() {
        this.counters().clear();
        this.stats().clear();
        this.gauges().clear();
        this.schemas().clear();
    }

    private HistogramDetail toHistogramDetail(Seq<Object> addedValues) {
        return new HistogramDetail(addedValues, this){
            private final Seq addedValues$1;
            {
                this.addedValues$1 = addedValues$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Seq counts() {
                return (Seq)((IterableOnceOps)this.addedValues$1.groupBy((Function1)((JFunction1.mcIF.sp & Serializable)InMemoryStatsReceiver::com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$1)).map(InMemoryStatsReceiver::com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$2)).toSeq().sortBy(InMemoryStatsReceiver::com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$3, (Ordering)Ordering.Long$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$1(float ), com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$2(scala.Tuple2 ), com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$3(com.twitter.finagle.stats.BucketAndCount )}, serializedLambda);
            }
        };
    }

    @Override
    public scala.collection.immutable.Map<String, HistogramDetail> histogramDetails() {
        return (scala.collection.immutable.Map)this.stats().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq k = (Seq)tuple2._1();
            Seq v = (Seq)tuple2._2();
            return Tuple2$.MODULE$.apply((Object)k.mkString("/"), (Object)this.toHistogramDetail((Seq<Object>)v));
        });
    }

    @Override
    public Try<BoxedUnit> registerExpression(ExpressionSchema schema) {
        return this.expressions().contains((Object)schema.schemaKey()) ? Throw$.MODULE$.apply((Throwable)ExpressionSchema$ExpressionCollisionException$.MODULE$.apply("An expression with the key " + schema.schemaKey() + " had already been defined.")) : Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.registerExpression$$anonfun$1(schema)));
    }

    public Map<ExpressionSchemaKey, ExpressionSchema> getAllExpressionsWithLabel(String key, String value) {
        return this.expressions().view().filterKeys((Function1 & Serializable)k -> {
            Option option = k.labels().get((Object)key);
            Some some = Some$.MODULE$.apply((Object)value);
            return !(option != null ? !option.equals(some) : some != null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final long com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$1$$_$apply$$anonfun$1() {
        return 0L;
    }

    public static final Seq com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$2$$_$apply$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ float com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$3$$_$$lessinit$greater$$anonfun$1(Function0 f$2) {
        return f$2.apply$mcF$sp();
    }

    private static final int nearestPosInt$1(float f) {
        return f < 0.0f ? 0 : (f >= (float)Integer.MAX_VALUE ? 0x7FFFFFFE : (int)f);
    }

    public static final /* synthetic */ int com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$1(float f) {
        return InMemoryStatsReceiver.nearestPosInt$1(f);
    }

    public static final /* synthetic */ BucketAndCount com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Seq vs = (Seq)tuple2._2();
        return BucketAndCount$.MODULE$.apply(Int$.MODULE$.int2long(k), Int$.MODULE$.int2long(k + 1), vs.size());
    }

    public static final /* synthetic */ long com$twitter$finagle$stats$InMemoryStatsReceiver$$anon$4$$_$counts$$anonfun$3(BucketAndCount _$5) {
        return _$5.lowerLimit();
    }

    private final void registerExpression$$anonfun$1(ExpressionSchema schema$1) {
        this.expressions().put((Object)schema$1.schemaKey(), (Object)schema$1);
    }

    public static class RichMap<K, V> {
        private final scala.collection.mutable.Map self;

        public RichMap(scala.collection.mutable.Map<K, V> self) {
            this.self = self;
        }

        public scala.collection.mutable.Map<K, V> self() {
            return this.self;
        }

        public <T> scala.collection.mutable.Map<T, V> mapKeys(Function1<K, T> func) {
            return (scala.collection.mutable.Map)this.self().withFilter((Function1 & Serializable)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Object object = Predef$.MODULE$.ArrowAssoc(func.apply(k));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, v);
            });
        }

        public SortedMap<K, V> toSortedMap(Ordering<K> ordering) {
            return (SortedMap)((SortedMapOps)SortedMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), ordering)).$plus$plus(this.self());
        }
    }
}

