/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security.exp;

import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class X509CertificateLoader$ {
    public static final X509CertificateLoader$ MODULE$;
    private final Logger log;

    static {
        new X509CertificateLoader$();
    }

    private boolean isReadableFile(File file) {
        return file.isFile() && file.canRead();
    }

    private X509Certificate readX509Certificate(InputStream inputStream) {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(inputStream);
    }

    private InputStream openStream(File certFile) {
        return new FileInputStream(certFile);
    }

    private void closeStream(InputStream inputStream) {
        inputStream.close();
    }

    private Try<InputStream> tryOpen(File certFile) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> this.openStream(certFile));
    }

    private Try<X509Certificate> tryRead(InputStream inputStream) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> this.readX509Certificate(inputStream)).ensure((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.closeStream(inputStream)));
    }

    private void logException(File certFile, Throwable ex) {
        this.log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X509Certificate (", ") failed to load: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certFile.getName(), ex.getMessage()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private void logNotReadableFile(File certFile) {
        this.log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"X509Certificate (", ") is not a file or is not readable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certFile.getName()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Option<X509Certificate> load(File certFile) {
        None$ none$;
        if (this.isReadableFile(certFile)) {
            none$ = this.tryOpen(certFile).flatMap((Function1 & java.io.Serializable & Serializable)inputStream -> this.tryRead((InputStream)inputStream)).onFailure((Function1 & java.io.Serializable & Serializable)ex -> {
                this.com$twitter$util$security$exp$X509CertificateLoader$$$anonfun$6(certFile, (Throwable)ex);
                return BoxedUnit.UNIT;
            }).toOption();
        } else {
            this.logNotReadableFile(certFile);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public final /* synthetic */ void com$twitter$util$security$exp$X509CertificateLoader$$$anonfun$6(File certFile$2, Throwable ex) {
        this.logException(certFile$2, ex);
    }

    private X509CertificateLoader$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.get("com.twitter.util.security");
    }
}

