/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.registry;

import com.twitter.util.registry.GlobalRegistry$;
import com.twitter.util.registry.Registry;
import java.util.logging.Logger;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;

public class Roster {
    private final Seq<String> scope;
    private final Set<String> keys;
    private final Logger log;
    private final Registry registry;

    public Roster(Seq<String> scope, Set<String> keys, Logger log) {
        this.scope = scope;
        this.keys = keys;
        this.log = log;
        this.registry = GlobalRegistry$.MODULE$.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(String key, String value) {
        if (!this.keys.apply((Object)key)) return false;
        Seq newKey = (Seq)this.scope.$colon$plus((Object)key);
        Option<String> result = this.registry.put((Seq<String>)newKey, value);
        if (result.isEmpty()) {
            String serialized = "\"(" + newKey.mkString(",") + ")\"";
            this.log.warning("expected there to be a value at key " + serialized + " in registry but it was empty.");
        }
        if (!result.isDefined()) return false;
        return true;
    }
}

