/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.LogRecord$;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;

public class LogRecord
extends java.util.logging.LogRecord {
    private boolean inferred = false;
    private String sourceClassName = null;
    private String sourceMethodName = null;

    public static String twitterString() {
        return LogRecord$.MODULE$.twitterString();
    }

    public LogRecord(Level level, String msg) {
        super(level, msg);
    }

    @Override
    public String getSourceClassName() {
        if (!this.inferred) {
            this.infer();
        }
        return this.sourceClassName;
    }

    @Override
    public String getSourceMethodName() {
        if (!this.inferred) {
            this.infer();
        }
        return this.sourceMethodName;
    }

    @Override
    public void setSourceClassName(String name) {
        this.inferred = true;
        this.sourceClassName = name;
    }

    @Override
    public void setSourceMethodName(String name) {
        this.inferred = true;
        this.sourceMethodName = name;
    }

    private void infer() {
        Tuple2 tuple2;
        Object[] stack = Thread.currentThread().getStackTrace();
        Object object = Predef$.MODULE$.refArrayOps(stack);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(object, (Function1 & Serializable)elt -> LogRecord.notTwitterString$1(elt)));
        Option elt2 = ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)elt -> LogRecord.notTwitterString$1(elt));
        Option option = elt2;
        if (option instanceof Some) {
            StackTraceElement element = (StackTraceElement)((Some)option).value();
            tuple2 = Tuple2$.MODULE$.apply((Object)element.getClassName(), (Object)element.getMethodName());
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = Tuple2$.MODULE$.apply((Object)super.getSourceClassName(), (Object)super.getSourceMethodName());
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple22 = tuple2;
        String cName = (String)tuple22._1();
        String mName = (String)tuple22._2();
        this.setSourceMethodName(mName);
        this.setSourceClassName(cName);
    }

    private static final boolean notTwitterString$1(StackTraceElement elt) {
        String string = elt.getClassName();
        String string2 = LogRecord$.MODULE$.twitterString();
        return string == null ? string2 != null : !string.equals(string2);
    }
}

