/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.jvm.Gc;
import com.twitter.jvm.Heap;
import com.twitter.jvm.Snapshot$;
import com.twitter.util.Time;
import java.io.Serializable;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Snapshot
implements Product,
Serializable {
    private final Time timestamp;
    private final Heap heap;
    private final Seq lastGcs;

    public static Snapshot apply(Time time, Heap heap, Seq<Gc> seq) {
        return Snapshot$.MODULE$.apply(time, heap, seq);
    }

    public static Snapshot fromProduct(Product product) {
        return Snapshot$.MODULE$.fromProduct(product);
    }

    public static Snapshot unapply(Snapshot snapshot) {
        return Snapshot$.MODULE$.unapply(snapshot);
    }

    public Snapshot(Time timestamp, Heap heap, Seq<Gc> lastGcs) {
        this.timestamp = timestamp;
        this.heap = heap;
        this.lastGcs = lastGcs;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Snapshot)) return false;
        Snapshot snapshot = (Snapshot)object;
        Time time = this.timestamp();
        Time time2 = snapshot.timestamp();
        if (time == null) {
            if (time2 != null) {
                return false;
            }
        } else if (!time.equals(time2)) return false;
        Heap heap = this.heap();
        Heap heap2 = snapshot.heap();
        if (heap == null) {
            if (heap2 != null) {
                return false;
            }
        } else if (!((Object)heap).equals(heap2)) return false;
        Seq<Gc> seq = this.lastGcs();
        Seq<Gc> seq2 = snapshot.lastGcs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!snapshot.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Snapshot;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Snapshot";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "timestamp";
                break;
            }
            case 1: {
                string = "heap";
                break;
            }
            case 2: {
                string = "lastGcs";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Time timestamp() {
        return this.timestamp;
    }

    public Heap heap() {
        return this.heap;
    }

    public Seq<Gc> lastGcs() {
        return this.lastGcs;
    }

    public Snapshot copy(Time timestamp, Heap heap, Seq<Gc> lastGcs) {
        return new Snapshot(timestamp, heap, lastGcs);
    }

    public Time copy$default$1() {
        return this.timestamp();
    }

    public Heap copy$default$2() {
        return this.heap();
    }

    public Seq<Gc> copy$default$3() {
        return this.lastGcs();
    }

    public Time _1() {
        return this.timestamp();
    }

    public Heap _2() {
        return this.heap();
    }

    public Seq<Gc> _3() {
        return this.lastGcs();
    }
}

