/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.jvm.Gc;
import com.twitter.jvm.Gc$;
import com.twitter.jvm.Heap;
import com.twitter.jvm.Jvm$;
import com.twitter.jvm.Jvm$MetaspaceUsage$;
import com.twitter.jvm.Pool;
import com.twitter.jvm.Safepoint;
import com.twitter.jvm.Snapshot;
import com.twitter.jvm.Snapshot$;
import com.twitter.util.Duration;
import com.twitter.util.StorageUnit;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileLongRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.function.JProcedure1;

public interface Jvm {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Jvm$.class, "0bitmap$1");

    public static Logger logger$(Jvm $this) {
        return $this.logger();
    }

    default public Logger logger() {
        return Jvm$.com$twitter$jvm$Jvm$$$log;
    }

    public Opts opts();

    public Map<String, String> snapCounters();

    public Snapshot snap();

    public Pool edenPool();

    public Option<MetaspaceUsage> metaspaceUsage();

    public long applicationTime();

    public long tenuringThreshold();

    public Safepoint safepoint();

    public static ScheduledExecutorService executor$(Jvm $this) {
        return $this.executor();
    }

    default public ScheduledExecutorService executor() {
        return Jvm$.MODULE$.com$twitter$jvm$Jvm$$$executor();
    }

    public static void foreachGc$(Jvm $this, Function1 f) {
        $this.foreachGc((Function1<Gc, BoxedUnit>)f);
    }

    default public void foreachGc(Function1<Gc, BoxedUnit> f) {
        Duration Period = DurationOps.RichDuration$.MODULE$.second$extension(DurationOps$.MODULE$.richDurationFromInt(1));
        Duration LogPeriod = DurationOps.RichDuration$.MODULE$.minutes$extension(DurationOps$.MODULE$.richDurationFromInt(30));
        VolatileLongRef missedCollections = VolatileLongRef.create((long)0L);
        VolatileObjectRef lastLog = VolatileObjectRef.create((Object)Time$.MODULE$.epoch());
        ConcurrentHashMap lastByName = new ConcurrentHashMap(16, 0.75f, 1);
        this.executor().scheduleAtFixedRate(new Runnable(f, LogPeriod, missedCollections, lastLog, lastByName, this){
            private final Function1 f$1;
            private final Duration LogPeriod$1;
            private final VolatileLongRef missedCollections$1;
            private final VolatileObjectRef lastLog$1;
            private final ConcurrentHashMap lastByName$1;
            private final Jvm $outer;
            {
                this.f$1 = f$4;
                this.LogPeriod$1 = LogPeriod$4;
                this.missedCollections$1 = missedCollections$4;
                this.lastLog$1 = lastLog$4;
                this.lastByName$1 = lastByName$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.com$twitter$jvm$Jvm$$_$sample$3(this.f$1, this.LogPeriod$1, this.missedCollections$1, this.lastLog$1, this.lastByName$1);
            }
        }, 0L, Period.inMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public static Function1 monitorGcs$(Jvm $this, Duration bufferFor) {
        return $this.monitorGcs(bufferFor);
    }

    default public Function1<Time, Seq<Gc>> monitorGcs(Duration bufferFor) {
        Predef$.MODULE$.require(bufferFor.$greater((Object)DurationOps.RichDuration$.MODULE$.seconds$extension(DurationOps$.MODULE$.richDurationFromInt(0))));
        VolatileObjectRef buffer = VolatileObjectRef.create((Object)package$.MODULE$.Nil());
        this.foreachGc((Function1<Gc, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
            Gc gc = x$1;
            if (gc == null) {
                throw new MatchError((Object)gc);
            }
            Gc gc2 = Gc$.MODULE$.unapply(gc);
            long l = gc2._1();
            String string = gc2._2();
            Time time = gc2._3();
            Duration duration = gc2._4();
            Time timestamp = time;
            Gc gc3 = gc;
            Time floor = (Time)timestamp.$minus(bufferFor);
            List list = ((List)buffer$1.elem).$colon$colon((Object)gc3).takeWhile((Function1 & Serializable)_$1 -> _$1.timestamp().$greater((Object)floor));
            buffer$1.elem = list;
        });
        return (Function1 & Serializable)since -> ((List)buffer$2.elem).takeWhile((Function1 & Serializable)_$2 -> _$2.timestamp().$greater(since));
    }

    public void forceGc();

    public static String mainClassName$(Jvm $this) {
        return $this.mainClassName();
    }

    default public String mainClassName() {
        Option mainClass = CollectionConverters$.MODULE$.MapHasAsScala(Thread.getAllStackTraces()).asScala().find((Function1 & Serializable)x$1 -> {
            String string;
            String string2;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Thread t = (Thread)tuple2._1();
                StackTraceElement[] s = (StackTraceElement[])tuple2._2();
                string2 = t.getName();
                string = "main";
            } else {
                throw new MatchError((Object)tuple2);
            }
            return !(string2 != null ? !string2.equals(string) : string != null);
        }).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StackTraceElement[] stack = (StackTraceElement[])tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object[] stack = (StackTraceElement[])tuple2._2();
            Object object = Predef$.MODULE$.refArrayOps(stack);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])((StackTraceElement[])ArrayOps$.MODULE$.reverse$extension(object)));
            return ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)elem -> !elem.getClassName().startsWith("scala.tools.nsc.MainGenericRunner")).map((Function1 & Serializable)frame -> frame.getClassName());
        });
        return (String)mainClass.getOrElse(Jvm::mainClassName$$anonfun$1);
    }

    public static void com$twitter$jvm$Jvm$$_$sample$3$(Jvm $this, Function1 f$1, Duration LogPeriod$1, VolatileLongRef missedCollections$1, VolatileObjectRef lastLog$1, ConcurrentHashMap lastByName$1) {
        $this.com$twitter$jvm$Jvm$$_$sample$3(f$1, LogPeriod$1, missedCollections$1, lastLog$1, lastByName$1);
    }

    default public void com$twitter$jvm$Jvm$$_$sample$3(Function1 f$1, Duration LogPeriod$1, VolatileLongRef missedCollections$1, VolatileObjectRef lastLog$1, ConcurrentHashMap lastByName$1) {
        Seq<Gc> seq;
        Snapshot snapshot = this.snap();
        if (snapshot == null) {
            throw new MatchError((Object)snapshot);
        }
        Snapshot snapshot2 = Snapshot$.MODULE$.unapply(snapshot);
        Time time = snapshot2._1();
        Heap heap = snapshot2._2();
        Seq<Gc> gcs = seq = snapshot2._3();
        Seq<Gc> gcs2 = gcs;
        gcs2.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Gc gc = x$1;
            if (gc != null) {
                Gc gc2 = Gc$.MODULE$.unapply(gc);
                long l = gc2._1();
                String string = gc2._2();
                Time time = gc2._3();
                Duration duration = gc2._4();
                long count = l;
                String name = string;
                Gc gc3 = gc;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1 & Serializable)x$1 -> {
            String name;
            long count;
            Gc gc = x$1;
            if (gc != null) {
                Gc gc2 = Gc$.MODULE$.unapply(gc);
                long l = gc2._1();
                String string = gc2._2();
                Time time = gc2._3();
                Duration duration = gc2._4();
                count = l;
                name = string;
                Gc gc3 = gc;
                Long lastCount = (Long)lastByName$1.get(name);
                if (lastCount == null) {
                    f$1.apply((Object)gc3);
                } else if (!BoxesRunTime.equals((Object)lastCount, (Object)BoxesRunTime.boxToLong((long)count))) {
                    long l2;
                    missedCollections$2.elem = l2 = missedCollections$2.elem + (count - 1L - Predef$.MODULE$.Long2long(lastCount));
                    if (missedCollections$2.elem > 0L && Time$.MODULE$.now().$minus((Time)lastLog$2.elem).$greater((Object)LogPeriod$1)) {
                        long l3;
                        if (this.logger().isLoggable(Level.FINE)) {
                            this.logger().fine(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Missed %d collections for %s due to sampling"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)missedCollections$2.elem), name})));
                        }
                        Time time2 = Time$.MODULE$.now();
                        lastLog$2.elem = time2;
                        missedCollections$2.elem = l3 = 0L;
                    }
                    f$1.apply((Object)gc3);
                }
            } else {
                throw new MatchError((Object)gc);
            }
            return lastByName$1.put(name, Predef$.MODULE$.long2Long(count));
        });
    }

    private static String mainClassName$$anonfun$1() {
        return "unknown";
    }

    public static class MetaspaceUsage
    implements Product,
    Serializable {
        private final StorageUnit used;
        private final StorageUnit capacity;
        private final StorageUnit maxCapacity;

        public static MetaspaceUsage apply(StorageUnit storageUnit, StorageUnit storageUnit2, StorageUnit storageUnit3) {
            return Jvm$MetaspaceUsage$.MODULE$.apply(storageUnit, storageUnit2, storageUnit3);
        }

        public static MetaspaceUsage fromProduct(Product product) {
            return Jvm$MetaspaceUsage$.MODULE$.fromProduct(product);
        }

        public static MetaspaceUsage unapply(MetaspaceUsage metaspaceUsage) {
            return Jvm$MetaspaceUsage$.MODULE$.unapply(metaspaceUsage);
        }

        public MetaspaceUsage(StorageUnit used, StorageUnit capacity, StorageUnit maxCapacity) {
            this.used = used;
            this.capacity = capacity;
            this.maxCapacity = maxCapacity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MetaspaceUsage)) return false;
            MetaspaceUsage metaspaceUsage = (MetaspaceUsage)object;
            StorageUnit storageUnit = this.used();
            StorageUnit storageUnit2 = metaspaceUsage.used();
            if (storageUnit == null) {
                if (storageUnit2 != null) {
                    return false;
                }
            } else if (!storageUnit.equals(storageUnit2)) return false;
            StorageUnit storageUnit3 = this.capacity();
            StorageUnit storageUnit4 = metaspaceUsage.capacity();
            if (storageUnit3 == null) {
                if (storageUnit4 != null) {
                    return false;
                }
            } else if (!storageUnit3.equals(storageUnit4)) return false;
            StorageUnit storageUnit5 = this.maxCapacity();
            StorageUnit storageUnit6 = metaspaceUsage.maxCapacity();
            if (storageUnit5 == null) {
                if (storageUnit6 != null) {
                    return false;
                }
            } else if (!storageUnit5.equals(storageUnit6)) return false;
            if (!metaspaceUsage.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MetaspaceUsage;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MetaspaceUsage";
        }

        public Object productElement(int n) {
            StorageUnit storageUnit;
            int n2 = n;
            switch (n2) {
                case 0: {
                    storageUnit = this._1();
                    break;
                }
                case 1: {
                    storageUnit = this._2();
                    break;
                }
                case 2: {
                    storageUnit = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return storageUnit;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "used";
                    break;
                }
                case 1: {
                    string = "capacity";
                    break;
                }
                case 2: {
                    string = "maxCapacity";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public StorageUnit used() {
            return this.used;
        }

        public StorageUnit capacity() {
            return this.capacity;
        }

        public StorageUnit maxCapacity() {
            return this.maxCapacity;
        }

        public MetaspaceUsage copy(StorageUnit used, StorageUnit capacity, StorageUnit maxCapacity) {
            return new MetaspaceUsage(used, capacity, maxCapacity);
        }

        public StorageUnit copy$default$1() {
            return this.used();
        }

        public StorageUnit copy$default$2() {
            return this.capacity();
        }

        public StorageUnit copy$default$3() {
            return this.maxCapacity();
        }

        public StorageUnit _1() {
            return this.used();
        }

        public StorageUnit _2() {
            return this.capacity();
        }

        public StorageUnit _3() {
            return this.maxCapacity();
        }
    }

    public interface Opts {
        public Option<Object> compileThresh();
    }
}

