/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class Kalman {
    private final int N;
    private final double[] mbuf;
    private final double[] ebuf;
    private double est;
    private long n;
    private double weight;

    public Kalman(int N) {
        this.N = N;
        this.mbuf = new double[N];
        this.ebuf = new double[N];
        this.n = 0L;
        this.weight = 0.9;
    }

    public void measure(double m, double e) {
        double ev;
        int i = (int)(this.n % (long)this.N);
        this.mbuf[i] = m;
        this.ebuf[i] = e;
        if (this.n == 0L) {
            this.est = m;
        }
        this.est += this.weight * (m - this.est);
        double mv = this.mvar();
        this.weight = mv + (ev = this.evar()) == 0.0 ? 1.0 : mv / (mv + ev);
        ++this.n;
    }

    private double mvar() {
        double[] dArray;
        if (this.n < (long)this.N) {
            Object object = Predef$.MODULE$.doubleArrayOps(this.mbuf);
            dArray = (double[])ArrayOps$.MODULE$.take$extension(object, (int)this.n);
        } else {
            dArray = this.mbuf;
        }
        return this.variance(dArray);
    }

    private double evar() {
        double[] dArray;
        if (this.n < (long)this.N) {
            Object object = Predef$.MODULE$.doubleArrayOps(this.ebuf);
            dArray = (double[])ArrayOps$.MODULE$.take$extension(object, (int)this.n);
        } else {
            dArray = this.ebuf;
        }
        return this.variance(dArray);
    }

    public double estimate() {
        return this.est;
    }

    private double variance(double[] samples) {
        if (samples.length == 1) {
            return 0.0;
        }
        double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(samples).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double mean = sum / (double)samples.length;
        Object object = Predef$.MODULE$.doubleArrayOps(samples);
        double diff = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcDD.sp & Serializable)x -> (x - mean) * (x - mean), ClassTag$.MODULE$.apply(Double.TYPE))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return diff / (double)(samples.length - 1);
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Kalman<estimate=%f, weight=%f, mvar=%f, evar=%f>"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToDouble((double)this.weight), BoxesRunTime.boxToDouble((double)this.mvar()), BoxesRunTime.boxToDouble((double)this.evar())}));
    }
}

